/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Order;
import java.util.List;
import java.util.Objects;

public class CalculateOrderResponse {
    private HttpContext httpContext;
    private final Order order;
    private final List<Error> errors;

    @JsonCreator
    public CalculateOrderResponse(@JsonProperty(value="order") Order order, @JsonProperty(value="errors") List<Error> errors) {
        this.order = order;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateOrderResponse)) {
            return false;
        }
        CalculateOrderResponse other = (CalculateOrderResponse)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "CalculateOrderResponse [order=" + this.order + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Order order;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public CalculateOrderResponse build() {
            CalculateOrderResponse model = new CalculateOrderResponse(this.order, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

