/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Card {
    private final String id;
    private final String cardBrand;
    private final String last4;
    private final OptionalNullable<Long> expMonth;
    private final OptionalNullable<Long> expYear;
    private final OptionalNullable<String> cardholderName;
    private final Address billingAddress;
    private final String fingerprint;
    private final OptionalNullable<String> customerId;
    private final String merchantId;
    private final OptionalNullable<String> referenceId;
    private final Boolean enabled;
    private final String cardType;
    private final String prepaidType;
    private final String bin;
    private final Long version;
    private final String cardCoBrand;

    @JsonCreator
    public Card(@JsonProperty(value="id") String id, @JsonProperty(value="card_brand") String cardBrand, @JsonProperty(value="last_4") String last4, @JsonProperty(value="exp_month") Long expMonth, @JsonProperty(value="exp_year") Long expYear, @JsonProperty(value="cardholder_name") String cardholderName, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="card_type") String cardType, @JsonProperty(value="prepaid_type") String prepaidType, @JsonProperty(value="bin") String bin, @JsonProperty(value="version") Long version, @JsonProperty(value="card_co_brand") String cardCoBrand) {
        this.id = id;
        this.cardBrand = cardBrand;
        this.last4 = last4;
        this.expMonth = OptionalNullable.of((Object)expMonth);
        this.expYear = OptionalNullable.of((Object)expYear);
        this.cardholderName = OptionalNullable.of((Object)cardholderName);
        this.billingAddress = billingAddress;
        this.fingerprint = fingerprint;
        this.customerId = OptionalNullable.of((Object)customerId);
        this.merchantId = merchantId;
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.enabled = enabled;
        this.cardType = cardType;
        this.prepaidType = prepaidType;
        this.bin = bin;
        this.version = version;
        this.cardCoBrand = cardCoBrand;
    }

    protected Card(String id, String cardBrand, String last4, OptionalNullable<Long> expMonth, OptionalNullable<Long> expYear, OptionalNullable<String> cardholderName, Address billingAddress, String fingerprint, OptionalNullable<String> customerId, String merchantId, OptionalNullable<String> referenceId, Boolean enabled, String cardType, String prepaidType, String bin, Long version, String cardCoBrand) {
        this.id = id;
        this.cardBrand = cardBrand;
        this.last4 = last4;
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cardholderName = cardholderName;
        this.billingAddress = billingAddress;
        this.fingerprint = fingerprint;
        this.customerId = customerId;
        this.merchantId = merchantId;
        this.referenceId = referenceId;
        this.enabled = enabled;
        this.cardType = cardType;
        this.prepaidType = prepaidType;
        this.bin = bin;
        this.version = version;
        this.cardCoBrand = cardCoBrand;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="card_brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardBrand() {
        return this.cardBrand;
    }

    @JsonGetter(value="last_4")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLast4() {
        return this.last4;
    }

    @JsonGetter(value="exp_month")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetExpMonth() {
        return this.expMonth;
    }

    @JsonIgnore
    public Long getExpMonth() {
        return (Long)OptionalNullable.getFrom(this.expMonth);
    }

    @JsonGetter(value="exp_year")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetExpYear() {
        return this.expYear;
    }

    @JsonIgnore
    public Long getExpYear() {
        return (Long)OptionalNullable.getFrom(this.expYear);
    }

    @JsonGetter(value="cardholder_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCardholderName() {
        return this.cardholderName;
    }

    @JsonIgnore
    public String getCardholderName() {
        return (String)OptionalNullable.getFrom(this.cardholderName);
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonGetter(value="card_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardType() {
        return this.cardType;
    }

    @JsonGetter(value="prepaid_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrepaidType() {
        return this.prepaidType;
    }

    @JsonGetter(value="bin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBin() {
        return this.bin;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    @JsonGetter(value="card_co_brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardCoBrand() {
        return this.cardCoBrand;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version, this.cardCoBrand);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Card)) {
            return false;
        }
        Card other = (Card)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.cardBrand, other.cardBrand) && Objects.equals(this.last4, other.last4) && Objects.equals(this.expMonth, other.expMonth) && Objects.equals(this.expYear, other.expYear) && Objects.equals(this.cardholderName, other.cardholderName) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.cardType, other.cardType) && Objects.equals(this.prepaidType, other.prepaidType) && Objects.equals(this.bin, other.bin) && Objects.equals(this.version, other.version) && Objects.equals(this.cardCoBrand, other.cardCoBrand);
    }

    public String toString() {
        return "Card [id=" + this.id + ", cardBrand=" + this.cardBrand + ", last4=" + this.last4 + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ", cardholderName=" + this.cardholderName + ", billingAddress=" + this.billingAddress + ", fingerprint=" + this.fingerprint + ", customerId=" + this.customerId + ", merchantId=" + this.merchantId + ", referenceId=" + this.referenceId + ", enabled=" + this.enabled + ", cardType=" + this.cardType + ", prepaidType=" + this.prepaidType + ", bin=" + this.bin + ", version=" + this.version + ", cardCoBrand=" + this.cardCoBrand + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).cardBrand(this.getCardBrand()).last4(this.getLast4()).billingAddress(this.getBillingAddress()).fingerprint(this.getFingerprint()).merchantId(this.getMerchantId()).enabled(this.getEnabled()).cardType(this.getCardType()).prepaidType(this.getPrepaidType()).bin(this.getBin()).version(this.getVersion()).cardCoBrand(this.getCardCoBrand());
        builder.expMonth = this.internalGetExpMonth();
        builder.expYear = this.internalGetExpYear();
        builder.cardholderName = this.internalGetCardholderName();
        builder.customerId = this.internalGetCustomerId();
        builder.referenceId = this.internalGetReferenceId();
        return builder;
    }

    public static class Builder {
        private String id;
        private String cardBrand;
        private String last4;
        private OptionalNullable<Long> expMonth;
        private OptionalNullable<Long> expYear;
        private OptionalNullable<String> cardholderName;
        private Address billingAddress;
        private String fingerprint;
        private OptionalNullable<String> customerId;
        private String merchantId;
        private OptionalNullable<String> referenceId;
        private Boolean enabled;
        private String cardType;
        private String prepaidType;
        private String bin;
        private Long version;
        private String cardCoBrand;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder cardBrand(String cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = last4;
            return this;
        }

        public Builder expMonth(Long expMonth) {
            this.expMonth = OptionalNullable.of((Object)expMonth);
            return this;
        }

        public Builder unsetExpMonth() {
            this.expMonth = null;
            return this;
        }

        public Builder expYear(Long expYear) {
            this.expYear = OptionalNullable.of((Object)expYear);
            return this;
        }

        public Builder unsetExpYear() {
            this.expYear = null;
            return this;
        }

        public Builder cardholderName(String cardholderName) {
            this.cardholderName = OptionalNullable.of((Object)cardholderName);
            return this;
        }

        public Builder unsetCardholderName() {
            this.cardholderName = null;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder cardType(String cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder prepaidType(String prepaidType) {
            this.prepaidType = prepaidType;
            return this;
        }

        public Builder bin(String bin) {
            this.bin = bin;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder cardCoBrand(String cardCoBrand) {
            this.cardCoBrand = cardCoBrand;
            return this;
        }

        public Card build() {
            return new Card(this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint, this.customerId, this.merchantId, this.referenceId, this.enabled, this.cardType, this.prepaidType, this.bin, this.version, this.cardCoBrand);
        }
    }
}

