/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CashDrawerDevice;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CashDrawerShift {
    private final String id;
    private final String state;
    private final OptionalNullable<String> openedAt;
    private final OptionalNullable<String> endedAt;
    private final OptionalNullable<String> closedAt;
    private final OptionalNullable<String> description;
    private final Money openedCashMoney;
    private final Money cashPaymentMoney;
    private final Money cashRefundsMoney;
    private final Money cashPaidInMoney;
    private final Money cashPaidOutMoney;
    private final Money expectedCashMoney;
    private final Money closedCashMoney;
    private final CashDrawerDevice device;
    private final String createdAt;
    private final String updatedAt;
    private final String locationId;
    private final List<String> teamMemberIds;
    private final String openingTeamMemberId;
    private final String endingTeamMemberId;
    private final String closingTeamMemberId;

    @JsonCreator
    public CashDrawerShift(@JsonProperty(value="id") String id, @JsonProperty(value="state") String state, @JsonProperty(value="opened_at") String openedAt, @JsonProperty(value="ended_at") String endedAt, @JsonProperty(value="closed_at") String closedAt, @JsonProperty(value="description") String description, @JsonProperty(value="opened_cash_money") Money openedCashMoney, @JsonProperty(value="cash_payment_money") Money cashPaymentMoney, @JsonProperty(value="cash_refunds_money") Money cashRefundsMoney, @JsonProperty(value="cash_paid_in_money") Money cashPaidInMoney, @JsonProperty(value="cash_paid_out_money") Money cashPaidOutMoney, @JsonProperty(value="expected_cash_money") Money expectedCashMoney, @JsonProperty(value="closed_cash_money") Money closedCashMoney, @JsonProperty(value="device") CashDrawerDevice device, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="team_member_ids") List<String> teamMemberIds, @JsonProperty(value="opening_team_member_id") String openingTeamMemberId, @JsonProperty(value="ending_team_member_id") String endingTeamMemberId, @JsonProperty(value="closing_team_member_id") String closingTeamMemberId) {
        this.id = id;
        this.state = state;
        this.openedAt = OptionalNullable.of((Object)openedAt);
        this.endedAt = OptionalNullable.of((Object)endedAt);
        this.closedAt = OptionalNullable.of((Object)closedAt);
        this.description = OptionalNullable.of((Object)description);
        this.openedCashMoney = openedCashMoney;
        this.cashPaymentMoney = cashPaymentMoney;
        this.cashRefundsMoney = cashRefundsMoney;
        this.cashPaidInMoney = cashPaidInMoney;
        this.cashPaidOutMoney = cashPaidOutMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.device = device;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
        this.teamMemberIds = teamMemberIds;
        this.openingTeamMemberId = openingTeamMemberId;
        this.endingTeamMemberId = endingTeamMemberId;
        this.closingTeamMemberId = closingTeamMemberId;
    }

    protected CashDrawerShift(String id, String state, OptionalNullable<String> openedAt, OptionalNullable<String> endedAt, OptionalNullable<String> closedAt, OptionalNullable<String> description, Money openedCashMoney, Money cashPaymentMoney, Money cashRefundsMoney, Money cashPaidInMoney, Money cashPaidOutMoney, Money expectedCashMoney, Money closedCashMoney, CashDrawerDevice device, String createdAt, String updatedAt, String locationId, List<String> teamMemberIds, String openingTeamMemberId, String endingTeamMemberId, String closingTeamMemberId) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.cashPaymentMoney = cashPaymentMoney;
        this.cashRefundsMoney = cashRefundsMoney;
        this.cashPaidInMoney = cashPaidInMoney;
        this.cashPaidOutMoney = cashPaidOutMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.device = device;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
        this.teamMemberIds = teamMemberIds;
        this.openingTeamMemberId = openingTeamMemberId;
        this.endingTeamMemberId = endingTeamMemberId;
        this.closingTeamMemberId = closingTeamMemberId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="opened_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOpenedAt() {
        return this.openedAt;
    }

    @JsonIgnore
    public String getOpenedAt() {
        return (String)OptionalNullable.getFrom(this.openedAt);
    }

    @JsonGetter(value="ended_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndedAt() {
        return this.endedAt;
    }

    @JsonIgnore
    public String getEndedAt() {
        return (String)OptionalNullable.getFrom(this.endedAt);
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetClosedAt() {
        return this.closedAt;
    }

    @JsonIgnore
    public String getClosedAt() {
        return (String)OptionalNullable.getFrom(this.closedAt);
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="opened_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonGetter(value="cash_payment_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaymentMoney() {
        return this.cashPaymentMoney;
    }

    @JsonGetter(value="cash_refunds_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashRefundsMoney() {
        return this.cashRefundsMoney;
    }

    @JsonGetter(value="cash_paid_in_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaidInMoney() {
        return this.cashPaidInMoney;
    }

    @JsonGetter(value="cash_paid_out_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getCashPaidOutMoney() {
        return this.cashPaidOutMoney;
    }

    @JsonGetter(value="expected_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonGetter(value="closed_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getClosedCashMoney() {
        return this.closedCashMoney;
    }

    @JsonGetter(value="device")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CashDrawerDevice getDevice() {
        return this.device;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="team_member_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTeamMemberIds() {
        return this.teamMemberIds;
    }

    @JsonGetter(value="opening_team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOpeningTeamMemberId() {
        return this.openingTeamMemberId;
    }

    @JsonGetter(value="ending_team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndingTeamMemberId() {
        return this.endingTeamMemberId;
    }

    @JsonGetter(value="closing_team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClosingTeamMemberId() {
        return this.closingTeamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device, this.createdAt, this.updatedAt, this.locationId, this.teamMemberIds, this.openingTeamMemberId, this.endingTeamMemberId, this.closingTeamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShift)) {
            return false;
        }
        CashDrawerShift other = (CashDrawerShift)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.state, other.state) && Objects.equals(this.openedAt, other.openedAt) && Objects.equals(this.endedAt, other.endedAt) && Objects.equals(this.closedAt, other.closedAt) && Objects.equals(this.description, other.description) && Objects.equals(this.openedCashMoney, other.openedCashMoney) && Objects.equals(this.cashPaymentMoney, other.cashPaymentMoney) && Objects.equals(this.cashRefundsMoney, other.cashRefundsMoney) && Objects.equals(this.cashPaidInMoney, other.cashPaidInMoney) && Objects.equals(this.cashPaidOutMoney, other.cashPaidOutMoney) && Objects.equals(this.expectedCashMoney, other.expectedCashMoney) && Objects.equals(this.closedCashMoney, other.closedCashMoney) && Objects.equals(this.device, other.device) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.teamMemberIds, other.teamMemberIds) && Objects.equals(this.openingTeamMemberId, other.openingTeamMemberId) && Objects.equals(this.endingTeamMemberId, other.endingTeamMemberId) && Objects.equals(this.closingTeamMemberId, other.closingTeamMemberId);
    }

    public String toString() {
        return "CashDrawerShift [id=" + this.id + ", state=" + this.state + ", openedAt=" + this.openedAt + ", endedAt=" + this.endedAt + ", closedAt=" + this.closedAt + ", description=" + this.description + ", openedCashMoney=" + this.openedCashMoney + ", cashPaymentMoney=" + this.cashPaymentMoney + ", cashRefundsMoney=" + this.cashRefundsMoney + ", cashPaidInMoney=" + this.cashPaidInMoney + ", cashPaidOutMoney=" + this.cashPaidOutMoney + ", expectedCashMoney=" + this.expectedCashMoney + ", closedCashMoney=" + this.closedCashMoney + ", device=" + this.device + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", locationId=" + this.locationId + ", teamMemberIds=" + this.teamMemberIds + ", openingTeamMemberId=" + this.openingTeamMemberId + ", endingTeamMemberId=" + this.endingTeamMemberId + ", closingTeamMemberId=" + this.closingTeamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).openedCashMoney(this.getOpenedCashMoney()).cashPaymentMoney(this.getCashPaymentMoney()).cashRefundsMoney(this.getCashRefundsMoney()).cashPaidInMoney(this.getCashPaidInMoney()).cashPaidOutMoney(this.getCashPaidOutMoney()).expectedCashMoney(this.getExpectedCashMoney()).closedCashMoney(this.getClosedCashMoney()).device(this.getDevice()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).locationId(this.getLocationId()).teamMemberIds(this.getTeamMemberIds()).openingTeamMemberId(this.getOpeningTeamMemberId()).endingTeamMemberId(this.getEndingTeamMemberId()).closingTeamMemberId(this.getClosingTeamMemberId());
        builder.openedAt = this.internalGetOpenedAt();
        builder.endedAt = this.internalGetEndedAt();
        builder.closedAt = this.internalGetClosedAt();
        builder.description = this.internalGetDescription();
        return builder;
    }

    public static class Builder {
        private String id;
        private String state;
        private OptionalNullable<String> openedAt;
        private OptionalNullable<String> endedAt;
        private OptionalNullable<String> closedAt;
        private OptionalNullable<String> description;
        private Money openedCashMoney;
        private Money cashPaymentMoney;
        private Money cashRefundsMoney;
        private Money cashPaidInMoney;
        private Money cashPaidOutMoney;
        private Money expectedCashMoney;
        private Money closedCashMoney;
        private CashDrawerDevice device;
        private String createdAt;
        private String updatedAt;
        private String locationId;
        private List<String> teamMemberIds;
        private String openingTeamMemberId;
        private String endingTeamMemberId;
        private String closingTeamMemberId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = OptionalNullable.of((Object)openedAt);
            return this;
        }

        public Builder unsetOpenedAt() {
            this.openedAt = null;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = OptionalNullable.of((Object)endedAt);
            return this;
        }

        public Builder unsetEndedAt() {
            this.endedAt = null;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = OptionalNullable.of((Object)closedAt);
            return this;
        }

        public Builder unsetClosedAt() {
            this.closedAt = null;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder cashPaymentMoney(Money cashPaymentMoney) {
            this.cashPaymentMoney = cashPaymentMoney;
            return this;
        }

        public Builder cashRefundsMoney(Money cashRefundsMoney) {
            this.cashRefundsMoney = cashRefundsMoney;
            return this;
        }

        public Builder cashPaidInMoney(Money cashPaidInMoney) {
            this.cashPaidInMoney = cashPaidInMoney;
            return this;
        }

        public Builder cashPaidOutMoney(Money cashPaidOutMoney) {
            this.cashPaidOutMoney = cashPaidOutMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public Builder device(CashDrawerDevice device) {
            this.device = device;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder openingTeamMemberId(String openingTeamMemberId) {
            this.openingTeamMemberId = openingTeamMemberId;
            return this;
        }

        public Builder endingTeamMemberId(String endingTeamMemberId) {
            this.endingTeamMemberId = endingTeamMemberId;
            return this;
        }

        public Builder closingTeamMemberId(String closingTeamMemberId) {
            this.closingTeamMemberId = closingTeamMemberId;
            return this;
        }

        public CashDrawerShift build() {
            return new CashDrawerShift(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device, this.createdAt, this.updatedAt, this.locationId, this.teamMemberIds, this.openingTeamMemberId, this.endingTeamMemberId, this.closingTeamMemberId);
        }
    }
}

