/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogCategory {
    private final OptionalNullable<String> name;
    private final OptionalNullable<List<String>> imageIds;

    @JsonCreator
    public CatalogCategory(@JsonProperty(value="name") String name, @JsonProperty(value="image_ids") List<String> imageIds) {
        this.name = OptionalNullable.of((Object)name);
        this.imageIds = OptionalNullable.of(imageIds);
    }

    protected CatalogCategory(OptionalNullable<String> name, OptionalNullable<List<String>> imageIds) {
        this.name = name;
        this.imageIds = imageIds;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetImageIds() {
        return this.imageIds;
    }

    @JsonIgnore
    public List<String> getImageIds() {
        return (List)OptionalNullable.getFrom(this.imageIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCategory)) {
            return false;
        }
        CatalogCategory other = (CatalogCategory)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.imageIds, other.imageIds);
    }

    public String toString() {
        return "CatalogCategory [name=" + this.name + ", imageIds=" + this.imageIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.name = this.internalGetName();
        builder.imageIds = this.internalGetImageIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private OptionalNullable<List<String>> imageIds;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = OptionalNullable.of(imageIds);
            return this;
        }

        public Builder unsetImageIds() {
            this.imageIds = null;
            return this;
        }

        public CatalogCategory build() {
            return new CatalogCategory(this.name, this.imageIds);
        }
    }
}

