/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogDiscount {
    private final OptionalNullable<String> name;
    private final String discountType;
    private final OptionalNullable<String> percentage;
    private final Money amountMoney;
    private final OptionalNullable<Boolean> pinRequired;
    private final OptionalNullable<String> labelColor;
    private final String modifyTaxBasis;
    private final Money maximumAmountMoney;

    @JsonCreator
    public CatalogDiscount(@JsonProperty(value="name") String name, @JsonProperty(value="discount_type") String discountType, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="pin_required") Boolean pinRequired, @JsonProperty(value="label_color") String labelColor, @JsonProperty(value="modify_tax_basis") String modifyTaxBasis, @JsonProperty(value="maximum_amount_money") Money maximumAmountMoney) {
        this.name = OptionalNullable.of((Object)name);
        this.discountType = discountType;
        this.percentage = OptionalNullable.of((Object)percentage);
        this.amountMoney = amountMoney;
        this.pinRequired = OptionalNullable.of((Object)pinRequired);
        this.labelColor = OptionalNullable.of((Object)labelColor);
        this.modifyTaxBasis = modifyTaxBasis;
        this.maximumAmountMoney = maximumAmountMoney;
    }

    protected CatalogDiscount(OptionalNullable<String> name, String discountType, OptionalNullable<String> percentage, Money amountMoney, OptionalNullable<Boolean> pinRequired, OptionalNullable<String> labelColor, String modifyTaxBasis, Money maximumAmountMoney) {
        this.name = name;
        this.discountType = discountType;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.pinRequired = pinRequired;
        this.labelColor = labelColor;
        this.modifyTaxBasis = modifyTaxBasis;
        this.maximumAmountMoney = maximumAmountMoney;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="discount_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDiscountType() {
        return this.discountType;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPercentage() {
        return this.percentage;
    }

    @JsonIgnore
    public String getPercentage() {
        return (String)OptionalNullable.getFrom(this.percentage);
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="pin_required")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetPinRequired() {
        return this.pinRequired;
    }

    @JsonIgnore
    public Boolean getPinRequired() {
        return (Boolean)OptionalNullable.getFrom(this.pinRequired);
    }

    @JsonGetter(value="label_color")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLabelColor() {
        return this.labelColor;
    }

    @JsonIgnore
    public String getLabelColor() {
        return (String)OptionalNullable.getFrom(this.labelColor);
    }

    @JsonGetter(value="modify_tax_basis")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getModifyTaxBasis() {
        return this.modifyTaxBasis;
    }

    @JsonGetter(value="maximum_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMaximumAmountMoney() {
        return this.maximumAmountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogDiscount)) {
            return false;
        }
        CatalogDiscount other = (CatalogDiscount)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.discountType, other.discountType) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.pinRequired, other.pinRequired) && Objects.equals(this.labelColor, other.labelColor) && Objects.equals(this.modifyTaxBasis, other.modifyTaxBasis) && Objects.equals(this.maximumAmountMoney, other.maximumAmountMoney);
    }

    public String toString() {
        return "CatalogDiscount [name=" + this.name + ", discountType=" + this.discountType + ", percentage=" + this.percentage + ", amountMoney=" + this.amountMoney + ", pinRequired=" + this.pinRequired + ", labelColor=" + this.labelColor + ", modifyTaxBasis=" + this.modifyTaxBasis + ", maximumAmountMoney=" + this.maximumAmountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().discountType(this.getDiscountType()).amountMoney(this.getAmountMoney()).modifyTaxBasis(this.getModifyTaxBasis()).maximumAmountMoney(this.getMaximumAmountMoney());
        builder.name = this.internalGetName();
        builder.percentage = this.internalGetPercentage();
        builder.pinRequired = this.internalGetPinRequired();
        builder.labelColor = this.internalGetLabelColor();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private String discountType;
        private OptionalNullable<String> percentage;
        private Money amountMoney;
        private OptionalNullable<Boolean> pinRequired;
        private OptionalNullable<String> labelColor;
        private String modifyTaxBasis;
        private Money maximumAmountMoney;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder discountType(String discountType) {
            this.discountType = discountType;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = OptionalNullable.of((Object)percentage);
            return this;
        }

        public Builder unsetPercentage() {
            this.percentage = null;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = OptionalNullable.of((Object)pinRequired);
            return this;
        }

        public Builder unsetPinRequired() {
            this.pinRequired = null;
            return this;
        }

        public Builder labelColor(String labelColor) {
            this.labelColor = OptionalNullable.of((Object)labelColor);
            return this;
        }

        public Builder unsetLabelColor() {
            this.labelColor = null;
            return this;
        }

        public Builder modifyTaxBasis(String modifyTaxBasis) {
            this.modifyTaxBasis = modifyTaxBasis;
            return this;
        }

        public Builder maximumAmountMoney(Money maximumAmountMoney) {
            this.maximumAmountMoney = maximumAmountMoney;
            return this;
        }

        public CatalogDiscount build() {
            return new CatalogDiscount(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney);
        }
    }
}

