/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogIdMapping {
    private final OptionalNullable<String> clientObjectId;
    private final OptionalNullable<String> objectId;

    @JsonCreator
    public CatalogIdMapping(@JsonProperty(value="client_object_id") String clientObjectId, @JsonProperty(value="object_id") String objectId) {
        this.clientObjectId = OptionalNullable.of((Object)clientObjectId);
        this.objectId = OptionalNullable.of((Object)objectId);
    }

    protected CatalogIdMapping(OptionalNullable<String> clientObjectId, OptionalNullable<String> objectId) {
        this.clientObjectId = clientObjectId;
        this.objectId = objectId;
    }

    @JsonGetter(value="client_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetClientObjectId() {
        return this.clientObjectId;
    }

    @JsonIgnore
    public String getClientObjectId() {
        return (String)OptionalNullable.getFrom(this.clientObjectId);
    }

    @JsonGetter(value="object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetObjectId() {
        return this.objectId;
    }

    @JsonIgnore
    public String getObjectId() {
        return (String)OptionalNullable.getFrom(this.objectId);
    }

    public int hashCode() {
        return Objects.hash(this.clientObjectId, this.objectId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogIdMapping)) {
            return false;
        }
        CatalogIdMapping other = (CatalogIdMapping)obj;
        return Objects.equals(this.clientObjectId, other.clientObjectId) && Objects.equals(this.objectId, other.objectId);
    }

    public String toString() {
        return "CatalogIdMapping [clientObjectId=" + this.clientObjectId + ", objectId=" + this.objectId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.clientObjectId = this.internalGetClientObjectId();
        builder.objectId = this.internalGetObjectId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> clientObjectId;
        private OptionalNullable<String> objectId;

        public Builder clientObjectId(String clientObjectId) {
            this.clientObjectId = OptionalNullable.of((Object)clientObjectId);
            return this;
        }

        public Builder unsetClientObjectId() {
            this.clientObjectId = null;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = OptionalNullable.of((Object)objectId);
            return this;
        }

        public Builder unsetObjectId() {
            this.objectId = null;
            return this;
        }

        public CatalogIdMapping build() {
            return new CatalogIdMapping(this.clientObjectId, this.objectId);
        }
    }
}

