/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogImage {
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> url;
    private final OptionalNullable<String> caption;
    private final OptionalNullable<String> photoStudioOrderId;

    @JsonCreator
    public CatalogImage(@JsonProperty(value="name") String name, @JsonProperty(value="url") String url, @JsonProperty(value="caption") String caption, @JsonProperty(value="photo_studio_order_id") String photoStudioOrderId) {
        this.name = OptionalNullable.of((Object)name);
        this.url = OptionalNullable.of((Object)url);
        this.caption = OptionalNullable.of((Object)caption);
        this.photoStudioOrderId = OptionalNullable.of((Object)photoStudioOrderId);
    }

    protected CatalogImage(OptionalNullable<String> name, OptionalNullable<String> url, OptionalNullable<String> caption, OptionalNullable<String> photoStudioOrderId) {
        this.name = name;
        this.url = url;
        this.caption = caption;
        this.photoStudioOrderId = photoStudioOrderId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUrl() {
        return this.url;
    }

    @JsonIgnore
    public String getUrl() {
        return (String)OptionalNullable.getFrom(this.url);
    }

    @JsonGetter(value="caption")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCaption() {
        return this.caption;
    }

    @JsonIgnore
    public String getCaption() {
        return (String)OptionalNullable.getFrom(this.caption);
    }

    @JsonGetter(value="photo_studio_order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhotoStudioOrderId() {
        return this.photoStudioOrderId;
    }

    @JsonIgnore
    public String getPhotoStudioOrderId() {
        return (String)OptionalNullable.getFrom(this.photoStudioOrderId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.caption, this.photoStudioOrderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogImage)) {
            return false;
        }
        CatalogImage other = (CatalogImage)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.url, other.url) && Objects.equals(this.caption, other.caption) && Objects.equals(this.photoStudioOrderId, other.photoStudioOrderId);
    }

    public String toString() {
        return "CatalogImage [name=" + this.name + ", url=" + this.url + ", caption=" + this.caption + ", photoStudioOrderId=" + this.photoStudioOrderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.name = this.internalGetName();
        builder.url = this.internalGetUrl();
        builder.caption = this.internalGetCaption();
        builder.photoStudioOrderId = this.internalGetPhotoStudioOrderId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private OptionalNullable<String> url;
        private OptionalNullable<String> caption;
        private OptionalNullable<String> photoStudioOrderId;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder url(String url) {
            this.url = OptionalNullable.of((Object)url);
            return this;
        }

        public Builder unsetUrl() {
            this.url = null;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = OptionalNullable.of((Object)caption);
            return this;
        }

        public Builder unsetCaption() {
            this.caption = null;
            return this;
        }

        public Builder photoStudioOrderId(String photoStudioOrderId) {
            this.photoStudioOrderId = OptionalNullable.of((Object)photoStudioOrderId);
            return this;
        }

        public Builder unsetPhotoStudioOrderId() {
            this.photoStudioOrderId = null;
            return this;
        }

        public CatalogImage build() {
            return new CatalogImage(this.name, this.url, this.caption, this.photoStudioOrderId);
        }
    }
}

