/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogObject;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogItemOption {
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> displayName;
    private final OptionalNullable<String> description;
    private final OptionalNullable<Boolean> showColors;
    private final OptionalNullable<List<CatalogObject>> values;

    @JsonCreator
    public CatalogItemOption(@JsonProperty(value="name") String name, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="show_colors") Boolean showColors, @JsonProperty(value="values") List<CatalogObject> values) {
        this.name = OptionalNullable.of((Object)name);
        this.displayName = OptionalNullable.of((Object)displayName);
        this.description = OptionalNullable.of((Object)description);
        this.showColors = OptionalNullable.of((Object)showColors);
        this.values = OptionalNullable.of(values);
    }

    protected CatalogItemOption(OptionalNullable<String> name, OptionalNullable<String> displayName, OptionalNullable<String> description, OptionalNullable<Boolean> showColors, OptionalNullable<List<CatalogObject>> values) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.showColors = showColors;
        this.values = values;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="display_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDisplayName() {
        return this.displayName;
    }

    @JsonIgnore
    public String getDisplayName() {
        return (String)OptionalNullable.getFrom(this.displayName);
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="show_colors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetShowColors() {
        return this.showColors;
    }

    @JsonIgnore
    public Boolean getShowColors() {
        return (Boolean)OptionalNullable.getFrom(this.showColors);
    }

    @JsonGetter(value="values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogObject>> internalGetValues() {
        return this.values;
    }

    @JsonIgnore
    public List<CatalogObject> getValues() {
        return (List)OptionalNullable.getFrom(this.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.showColors, this.values);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemOption)) {
            return false;
        }
        CatalogItemOption other = (CatalogItemOption)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.showColors, other.showColors) && Objects.equals(this.values, other.values);
    }

    public String toString() {
        return "CatalogItemOption [name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", showColors=" + this.showColors + ", values=" + this.values + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.name = this.internalGetName();
        builder.displayName = this.internalGetDisplayName();
        builder.description = this.internalGetDescription();
        builder.showColors = this.internalGetShowColors();
        builder.values = this.internalGetValues();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private OptionalNullable<String> displayName;
        private OptionalNullable<String> description;
        private OptionalNullable<Boolean> showColors;
        private OptionalNullable<List<CatalogObject>> values;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = OptionalNullable.of((Object)displayName);
            return this;
        }

        public Builder unsetDisplayName() {
            this.displayName = null;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder showColors(Boolean showColors) {
            this.showColors = OptionalNullable.of((Object)showColors);
            return this;
        }

        public Builder unsetShowColors() {
            this.showColors = null;
            return this;
        }

        public Builder values(List<CatalogObject> values) {
            this.values = OptionalNullable.of(values);
            return this;
        }

        public Builder unsetValues() {
            this.values = null;
            return this;
        }

        public CatalogItemOption build() {
            return new CatalogItemOption(this.name, this.displayName, this.description, this.showColors, this.values);
        }
    }
}

