/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.MeasurementUnit;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogMeasurementUnit {
    private final MeasurementUnit measurementUnit;
    private final OptionalNullable<Integer> precision;

    @JsonCreator
    public CatalogMeasurementUnit(@JsonProperty(value="measurement_unit") MeasurementUnit measurementUnit, @JsonProperty(value="precision") Integer precision) {
        this.measurementUnit = measurementUnit;
        this.precision = OptionalNullable.of((Object)precision);
    }

    protected CatalogMeasurementUnit(MeasurementUnit measurementUnit, OptionalNullable<Integer> precision) {
        this.measurementUnit = measurementUnit;
        this.precision = precision;
    }

    @JsonGetter(value="measurement_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonGetter(value="precision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetPrecision() {
        return this.precision;
    }

    @JsonIgnore
    public Integer getPrecision() {
        return (Integer)OptionalNullable.getFrom(this.precision);
    }

    public int hashCode() {
        return Objects.hash(this.measurementUnit, this.precision);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogMeasurementUnit)) {
            return false;
        }
        CatalogMeasurementUnit other = (CatalogMeasurementUnit)obj;
        return Objects.equals(this.measurementUnit, other.measurementUnit) && Objects.equals(this.precision, other.precision);
    }

    public String toString() {
        return "CatalogMeasurementUnit [measurementUnit=" + this.measurementUnit + ", precision=" + this.precision + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().measurementUnit(this.getMeasurementUnit());
        builder.precision = this.internalGetPrecision();
        return builder;
    }

    public static class Builder {
        private MeasurementUnit measurementUnit;
        private OptionalNullable<Integer> precision;

        public Builder measurementUnit(MeasurementUnit measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = OptionalNullable.of((Object)precision);
            return this;
        }

        public Builder unsetPrecision() {
            this.precision = null;
            return this;
        }

        public CatalogMeasurementUnit build() {
            return new CatalogMeasurementUnit(this.measurementUnit, this.precision);
        }
    }
}

