/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObject;
import java.util.List;
import java.util.Objects;

public class CatalogObjectBatch {
    private final List<CatalogObject> objects;

    @JsonCreator
    public CatalogObjectBatch(@JsonProperty(value="objects") List<CatalogObject> objects) {
        this.objects = objects;
    }

    @JsonGetter(value="objects")
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public int hashCode() {
        return Objects.hash(this.objects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogObjectBatch)) {
            return false;
        }
        CatalogObjectBatch other = (CatalogObjectBatch)obj;
        return Objects.equals(this.objects, other.objects);
    }

    public String toString() {
        return "CatalogObjectBatch [objects=" + this.objects + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.objects);
        return builder;
    }

    public static class Builder {
        private List<CatalogObject> objects;

        public Builder(List<CatalogObject> objects) {
            this.objects = objects;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = objects;
            return this;
        }

        public CatalogObjectBatch build() {
            return new CatalogObjectBatch(this.objects);
        }
    }
}

