/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogObjectReference {
    private final OptionalNullable<String> objectId;
    private final OptionalNullable<Long> catalogVersion;

    @JsonCreator
    public CatalogObjectReference(@JsonProperty(value="object_id") String objectId, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.objectId = OptionalNullable.of((Object)objectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
    }

    protected CatalogObjectReference(OptionalNullable<String> objectId, OptionalNullable<Long> catalogVersion) {
        this.objectId = objectId;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetObjectId() {
        return this.objectId;
    }

    @JsonIgnore
    public String getObjectId() {
        return (String)OptionalNullable.getFrom(this.objectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    public int hashCode() {
        return Objects.hash(this.objectId, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogObjectReference)) {
            return false;
        }
        CatalogObjectReference other = (CatalogObjectReference)obj;
        return Objects.equals(this.objectId, other.objectId) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "CatalogObjectReference [objectId=" + this.objectId + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.objectId = this.internalGetObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> objectId;
        private OptionalNullable<Long> catalogVersion;

        public Builder objectId(String objectId) {
            this.objectId = OptionalNullable.of((Object)objectId);
            return this;
        }

        public Builder unsetObjectId() {
            this.objectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public CatalogObjectReference build() {
            return new CatalogObjectReference(this.objectId, this.catalogVersion);
        }
    }
}

