/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogQuerySortedAttribute {
    private final String attributeName;
    private final OptionalNullable<String> initialAttributeValue;
    private final String sortOrder;

    @JsonCreator
    public CatalogQuerySortedAttribute(@JsonProperty(value="attribute_name") String attributeName, @JsonProperty(value="initial_attribute_value") String initialAttributeValue, @JsonProperty(value="sort_order") String sortOrder) {
        this.attributeName = attributeName;
        this.initialAttributeValue = OptionalNullable.of((Object)initialAttributeValue);
        this.sortOrder = sortOrder;
    }

    protected CatalogQuerySortedAttribute(String attributeName, OptionalNullable<String> initialAttributeValue, String sortOrder) {
        this.attributeName = attributeName;
        this.initialAttributeValue = initialAttributeValue;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonGetter(value="initial_attribute_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetInitialAttributeValue() {
        return this.initialAttributeValue;
    }

    @JsonIgnore
    public String getInitialAttributeValue() {
        return (String)OptionalNullable.getFrom(this.initialAttributeValue);
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.initialAttributeValue, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQuerySortedAttribute)) {
            return false;
        }
        CatalogQuerySortedAttribute other = (CatalogQuerySortedAttribute)obj;
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.initialAttributeValue, other.initialAttributeValue) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "CatalogQuerySortedAttribute [attributeName=" + this.attributeName + ", initialAttributeValue=" + this.initialAttributeValue + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.attributeName).sortOrder(this.getSortOrder());
        builder.initialAttributeValue = this.internalGetInitialAttributeValue();
        return builder;
    }

    public static class Builder {
        private String attributeName;
        private OptionalNullable<String> initialAttributeValue;
        private String sortOrder;

        public Builder(String attributeName) {
            this.attributeName = attributeName;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder initialAttributeValue(String initialAttributeValue) {
            this.initialAttributeValue = OptionalNullable.of((Object)initialAttributeValue);
            return this;
        }

        public Builder unsetInitialAttributeValue() {
            this.initialAttributeValue = null;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public CatalogQuerySortedAttribute build() {
            return new CatalogQuerySortedAttribute(this.attributeName, this.initialAttributeValue, this.sortOrder);
        }
    }
}

