/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogQuickAmount {
    private final String type;
    private final Money amount;
    private final OptionalNullable<Long> score;
    private final OptionalNullable<Long> ordinal;

    @JsonCreator
    public CatalogQuickAmount(@JsonProperty(value="type") String type, @JsonProperty(value="amount") Money amount, @JsonProperty(value="score") Long score, @JsonProperty(value="ordinal") Long ordinal) {
        this.type = type;
        this.amount = amount;
        this.score = OptionalNullable.of((Object)score);
        this.ordinal = OptionalNullable.of((Object)ordinal);
    }

    protected CatalogQuickAmount(String type, Money amount, OptionalNullable<Long> score, OptionalNullable<Long> ordinal) {
        this.type = type;
        this.amount = amount;
        this.score = score;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="amount")
    public Money getAmount() {
        return this.amount;
    }

    @JsonGetter(value="score")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetScore() {
        return this.score;
    }

    @JsonIgnore
    public Long getScore() {
        return (Long)OptionalNullable.getFrom(this.score);
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Long getOrdinal() {
        return (Long)OptionalNullable.getFrom(this.ordinal);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.amount, this.score, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQuickAmount)) {
            return false;
        }
        CatalogQuickAmount other = (CatalogQuickAmount)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.amount, other.amount) && Objects.equals(this.score, other.score) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "CatalogQuickAmount [type=" + this.type + ", amount=" + this.amount + ", score=" + this.score + ", ordinal=" + this.ordinal + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type, this.amount);
        builder.score = this.internalGetScore();
        builder.ordinal = this.internalGetOrdinal();
        return builder;
    }

    public static class Builder {
        private String type;
        private Money amount;
        private OptionalNullable<Long> score;
        private OptionalNullable<Long> ordinal;

        public Builder(String type, Money amount) {
            this.type = type;
            this.amount = amount;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder score(Long score) {
            this.score = OptionalNullable.of((Object)score);
            return this;
        }

        public Builder unsetScore() {
            this.score = null;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = OptionalNullable.of((Object)ordinal);
            return this;
        }

        public Builder unsetOrdinal() {
            this.ordinal = null;
            return this;
        }

        public CatalogQuickAmount build() {
            return new CatalogQuickAmount(this.type, this.amount, this.score, this.ordinal);
        }
    }
}

