/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.SubscriptionPhase;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogSubscriptionPlan {
    private final String name;
    private final OptionalNullable<List<SubscriptionPhase>> phases;
    private final OptionalNullable<List<CatalogObject>> subscriptionPlanVariations;
    private final OptionalNullable<List<String>> eligibleItemIds;
    private final OptionalNullable<List<String>> eligibleCategoryIds;
    private final OptionalNullable<Boolean> allItems;

    @JsonCreator
    public CatalogSubscriptionPlan(@JsonProperty(value="name") String name, @JsonProperty(value="phases") List<SubscriptionPhase> phases, @JsonProperty(value="subscription_plan_variations") List<CatalogObject> subscriptionPlanVariations, @JsonProperty(value="eligible_item_ids") List<String> eligibleItemIds, @JsonProperty(value="eligible_category_ids") List<String> eligibleCategoryIds, @JsonProperty(value="all_items") Boolean allItems) {
        this.name = name;
        this.phases = OptionalNullable.of(phases);
        this.subscriptionPlanVariations = OptionalNullable.of(subscriptionPlanVariations);
        this.eligibleItemIds = OptionalNullable.of(eligibleItemIds);
        this.eligibleCategoryIds = OptionalNullable.of(eligibleCategoryIds);
        this.allItems = OptionalNullable.of((Object)allItems);
    }

    protected CatalogSubscriptionPlan(String name, OptionalNullable<List<SubscriptionPhase>> phases, OptionalNullable<List<CatalogObject>> subscriptionPlanVariations, OptionalNullable<List<String>> eligibleItemIds, OptionalNullable<List<String>> eligibleCategoryIds, OptionalNullable<Boolean> allItems) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanVariations = subscriptionPlanVariations;
        this.eligibleItemIds = eligibleItemIds;
        this.eligibleCategoryIds = eligibleCategoryIds;
        this.allItems = allItems;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<SubscriptionPhase>> internalGetPhases() {
        return this.phases;
    }

    @JsonIgnore
    public List<SubscriptionPhase> getPhases() {
        return (List)OptionalNullable.getFrom(this.phases);
    }

    @JsonGetter(value="subscription_plan_variations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogObject>> internalGetSubscriptionPlanVariations() {
        return this.subscriptionPlanVariations;
    }

    @JsonIgnore
    public List<CatalogObject> getSubscriptionPlanVariations() {
        return (List)OptionalNullable.getFrom(this.subscriptionPlanVariations);
    }

    @JsonGetter(value="eligible_item_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetEligibleItemIds() {
        return this.eligibleItemIds;
    }

    @JsonIgnore
    public List<String> getEligibleItemIds() {
        return (List)OptionalNullable.getFrom(this.eligibleItemIds);
    }

    @JsonGetter(value="eligible_category_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetEligibleCategoryIds() {
        return this.eligibleCategoryIds;
    }

    @JsonIgnore
    public List<String> getEligibleCategoryIds() {
        return (List)OptionalNullable.getFrom(this.eligibleCategoryIds);
    }

    @JsonGetter(value="all_items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAllItems() {
        return this.allItems;
    }

    @JsonIgnore
    public Boolean getAllItems() {
        return (Boolean)OptionalNullable.getFrom(this.allItems);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.subscriptionPlanVariations, this.eligibleItemIds, this.eligibleCategoryIds, this.allItems);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogSubscriptionPlan)) {
            return false;
        }
        CatalogSubscriptionPlan other = (CatalogSubscriptionPlan)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases) && Objects.equals(this.subscriptionPlanVariations, other.subscriptionPlanVariations) && Objects.equals(this.eligibleItemIds, other.eligibleItemIds) && Objects.equals(this.eligibleCategoryIds, other.eligibleCategoryIds) && Objects.equals(this.allItems, other.allItems);
    }

    public String toString() {
        return "CatalogSubscriptionPlan [name=" + this.name + ", phases=" + this.phases + ", subscriptionPlanVariations=" + this.subscriptionPlanVariations + ", eligibleItemIds=" + this.eligibleItemIds + ", eligibleCategoryIds=" + this.eligibleCategoryIds + ", allItems=" + this.allItems + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name);
        builder.phases = this.internalGetPhases();
        builder.subscriptionPlanVariations = this.internalGetSubscriptionPlanVariations();
        builder.eligibleItemIds = this.internalGetEligibleItemIds();
        builder.eligibleCategoryIds = this.internalGetEligibleCategoryIds();
        builder.allItems = this.internalGetAllItems();
        return builder;
    }

    public static class Builder {
        private String name;
        private OptionalNullable<List<SubscriptionPhase>> phases;
        private OptionalNullable<List<CatalogObject>> subscriptionPlanVariations;
        private OptionalNullable<List<String>> eligibleItemIds;
        private OptionalNullable<List<String>> eligibleCategoryIds;
        private OptionalNullable<Boolean> allItems;

        public Builder(String name) {
            this.name = name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phases(List<SubscriptionPhase> phases) {
            this.phases = OptionalNullable.of(phases);
            return this;
        }

        public Builder unsetPhases() {
            this.phases = null;
            return this;
        }

        public Builder subscriptionPlanVariations(List<CatalogObject> subscriptionPlanVariations) {
            this.subscriptionPlanVariations = OptionalNullable.of(subscriptionPlanVariations);
            return this;
        }

        public Builder unsetSubscriptionPlanVariations() {
            this.subscriptionPlanVariations = null;
            return this;
        }

        public Builder eligibleItemIds(List<String> eligibleItemIds) {
            this.eligibleItemIds = OptionalNullable.of(eligibleItemIds);
            return this;
        }

        public Builder unsetEligibleItemIds() {
            this.eligibleItemIds = null;
            return this;
        }

        public Builder eligibleCategoryIds(List<String> eligibleCategoryIds) {
            this.eligibleCategoryIds = OptionalNullable.of(eligibleCategoryIds);
            return this;
        }

        public Builder unsetEligibleCategoryIds() {
            this.eligibleCategoryIds = null;
            return this;
        }

        public Builder allItems(Boolean allItems) {
            this.allItems = OptionalNullable.of((Object)allItems);
            return this;
        }

        public Builder unsetAllItems() {
            this.allItems = null;
            return this;
        }

        public CatalogSubscriptionPlan build() {
            return new CatalogSubscriptionPlan(this.name, this.phases, this.subscriptionPlanVariations, this.eligibleItemIds, this.eligibleCategoryIds, this.allItems);
        }
    }
}

