/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.SubscriptionPhase;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogSubscriptionPlanVariation {
    private final String name;
    private final List<SubscriptionPhase> phases;
    private final OptionalNullable<String> subscriptionPlanId;

    @JsonCreator
    public CatalogSubscriptionPlanVariation(@JsonProperty(value="name") String name, @JsonProperty(value="phases") List<SubscriptionPhase> phases, @JsonProperty(value="subscription_plan_id") String subscriptionPlanId) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
    }

    protected CatalogSubscriptionPlanVariation(String name, List<SubscriptionPhase> phases, OptionalNullable<String> subscriptionPlanId) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanId = subscriptionPlanId;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="phases")
    public List<SubscriptionPhase> getPhases() {
        return this.phases;
    }

    @JsonGetter(value="subscription_plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonIgnore
    public String getSubscriptionPlanId() {
        return (String)OptionalNullable.getFrom(this.subscriptionPlanId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.subscriptionPlanId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogSubscriptionPlanVariation)) {
            return false;
        }
        CatalogSubscriptionPlanVariation other = (CatalogSubscriptionPlanVariation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases) && Objects.equals(this.subscriptionPlanId, other.subscriptionPlanId);
    }

    public String toString() {
        return "CatalogSubscriptionPlanVariation [name=" + this.name + ", phases=" + this.phases + ", subscriptionPlanId=" + this.subscriptionPlanId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.phases);
        builder.subscriptionPlanId = this.internalGetSubscriptionPlanId();
        return builder;
    }

    public static class Builder {
        private String name;
        private List<SubscriptionPhase> phases;
        private OptionalNullable<String> subscriptionPlanId;

        public Builder(String name, List<SubscriptionPhase> phases) {
            this.name = name;
            this.phases = phases;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phases(List<SubscriptionPhase> phases) {
            this.phases = phases;
            return this;
        }

        public Builder subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
            return this;
        }

        public Builder unsetSubscriptionPlanId() {
            this.subscriptionPlanId = null;
            return this;
        }

        public CatalogSubscriptionPlanVariation build() {
            return new CatalogSubscriptionPlanVariation(this.name, this.phases, this.subscriptionPlanId);
        }
    }
}

