/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogTax {
    private final OptionalNullable<String> name;
    private final String calculationPhase;
    private final String inclusionType;
    private final OptionalNullable<String> percentage;
    private final OptionalNullable<Boolean> appliesToCustomAmounts;
    private final OptionalNullable<Boolean> enabled;
    private final OptionalNullable<String> appliesToProductSetId;

    @JsonCreator
    public CatalogTax(@JsonProperty(value="name") String name, @JsonProperty(value="calculation_phase") String calculationPhase, @JsonProperty(value="inclusion_type") String inclusionType, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="applies_to_custom_amounts") Boolean appliesToCustomAmounts, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="applies_to_product_set_id") String appliesToProductSetId) {
        this.name = OptionalNullable.of((Object)name);
        this.calculationPhase = calculationPhase;
        this.inclusionType = inclusionType;
        this.percentage = OptionalNullable.of((Object)percentage);
        this.appliesToCustomAmounts = OptionalNullable.of((Object)appliesToCustomAmounts);
        this.enabled = OptionalNullable.of((Object)enabled);
        this.appliesToProductSetId = OptionalNullable.of((Object)appliesToProductSetId);
    }

    protected CatalogTax(OptionalNullable<String> name, String calculationPhase, String inclusionType, OptionalNullable<String> percentage, OptionalNullable<Boolean> appliesToCustomAmounts, OptionalNullable<Boolean> enabled, OptionalNullable<String> appliesToProductSetId) {
        this.name = name;
        this.calculationPhase = calculationPhase;
        this.inclusionType = inclusionType;
        this.percentage = percentage;
        this.appliesToCustomAmounts = appliesToCustomAmounts;
        this.enabled = enabled;
        this.appliesToProductSetId = appliesToProductSetId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="calculation_phase")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonGetter(value="inclusion_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInclusionType() {
        return this.inclusionType;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPercentage() {
        return this.percentage;
    }

    @JsonIgnore
    public String getPercentage() {
        return (String)OptionalNullable.getFrom(this.percentage);
    }

    @JsonGetter(value="applies_to_custom_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAppliesToCustomAmounts() {
        return this.appliesToCustomAmounts;
    }

    @JsonIgnore
    public Boolean getAppliesToCustomAmounts() {
        return (Boolean)OptionalNullable.getFrom(this.appliesToCustomAmounts);
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public Boolean getEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.enabled);
    }

    @JsonGetter(value="applies_to_product_set_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAppliesToProductSetId() {
        return this.appliesToProductSetId;
    }

    @JsonIgnore
    public String getAppliesToProductSetId() {
        return (String)OptionalNullable.getFrom(this.appliesToProductSetId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled, this.appliesToProductSetId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogTax)) {
            return false;
        }
        CatalogTax other = (CatalogTax)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.calculationPhase, other.calculationPhase) && Objects.equals(this.inclusionType, other.inclusionType) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.appliesToCustomAmounts, other.appliesToCustomAmounts) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.appliesToProductSetId, other.appliesToProductSetId);
    }

    public String toString() {
        return "CatalogTax [name=" + this.name + ", calculationPhase=" + this.calculationPhase + ", inclusionType=" + this.inclusionType + ", percentage=" + this.percentage + ", appliesToCustomAmounts=" + this.appliesToCustomAmounts + ", enabled=" + this.enabled + ", appliesToProductSetId=" + this.appliesToProductSetId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().calculationPhase(this.getCalculationPhase()).inclusionType(this.getInclusionType());
        builder.name = this.internalGetName();
        builder.percentage = this.internalGetPercentage();
        builder.appliesToCustomAmounts = this.internalGetAppliesToCustomAmounts();
        builder.enabled = this.internalGetEnabled();
        builder.appliesToProductSetId = this.internalGetAppliesToProductSetId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private String calculationPhase;
        private String inclusionType;
        private OptionalNullable<String> percentage;
        private OptionalNullable<Boolean> appliesToCustomAmounts;
        private OptionalNullable<Boolean> enabled;
        private OptionalNullable<String> appliesToProductSetId;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder calculationPhase(String calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder inclusionType(String inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = OptionalNullable.of((Object)percentage);
            return this;
        }

        public Builder unsetPercentage() {
            this.percentage = null;
            return this;
        }

        public Builder appliesToCustomAmounts(Boolean appliesToCustomAmounts) {
            this.appliesToCustomAmounts = OptionalNullable.of((Object)appliesToCustomAmounts);
            return this;
        }

        public Builder unsetAppliesToCustomAmounts() {
            this.appliesToCustomAmounts = null;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = OptionalNullable.of((Object)enabled);
            return this;
        }

        public Builder unsetEnabled() {
            this.enabled = null;
            return this;
        }

        public Builder appliesToProductSetId(String appliesToProductSetId) {
            this.appliesToProductSetId = OptionalNullable.of((Object)appliesToProductSetId);
            return this;
        }

        public Builder unsetAppliesToProductSetId() {
            this.appliesToProductSetId = null;
            return this;
        }

        public CatalogTax build() {
            return new CatalogTax(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled, this.appliesToProductSetId);
        }
    }
}

