/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogV1Id {
    private final OptionalNullable<String> catalogV1Id;
    private final OptionalNullable<String> locationId;

    @JsonCreator
    public CatalogV1Id(@JsonProperty(value="catalog_v1_id") String catalogV1Id, @JsonProperty(value="location_id") String locationId) {
        this.catalogV1Id = OptionalNullable.of((Object)catalogV1Id);
        this.locationId = OptionalNullable.of((Object)locationId);
    }

    protected CatalogV1Id(OptionalNullable<String> catalogV1Id, OptionalNullable<String> locationId) {
        this.catalogV1Id = catalogV1Id;
        this.locationId = locationId;
    }

    @JsonGetter(value="catalog_v1_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogV1Id() {
        return this.catalogV1Id;
    }

    @JsonIgnore
    public String getCatalogV1Id() {
        return (String)OptionalNullable.getFrom(this.catalogV1Id);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.catalogV1Id, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogV1Id)) {
            return false;
        }
        CatalogV1Id other = (CatalogV1Id)obj;
        return Objects.equals(this.catalogV1Id, other.catalogV1Id) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "CatalogV1Id [catalogV1Id=" + this.catalogV1Id + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.catalogV1Id = this.internalGetCatalogV1Id();
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> catalogV1Id;
        private OptionalNullable<String> locationId;

        public Builder catalogV1Id(String catalogV1Id) {
            this.catalogV1Id = OptionalNullable.of((Object)catalogV1Id);
            return this;
        }

        public Builder unsetCatalogV1Id() {
            this.catalogV1Id = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public CatalogV1Id build() {
            return new CatalogV1Id(this.catalogV1Id, this.locationId);
        }
    }
}

