/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import com.squareup.square.models.ChargeRequestAdditionalRecipient;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class ChargeRequest {
    private final String idempotencyKey;
    private final Money amountMoney;
    private final OptionalNullable<String> cardNonce;
    private final OptionalNullable<String> customerCardId;
    private final OptionalNullable<Boolean> delayCapture;
    private final OptionalNullable<String> referenceId;
    private final OptionalNullable<String> note;
    private final OptionalNullable<String> customerId;
    private final Address billingAddress;
    private final Address shippingAddress;
    private final OptionalNullable<String> buyerEmailAddress;
    private final OptionalNullable<String> orderId;
    private final OptionalNullable<List<ChargeRequestAdditionalRecipient>> additionalRecipients;
    private final OptionalNullable<String> verificationToken;

    @JsonCreator
    public ChargeRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="card_nonce") String cardNonce, @JsonProperty(value="customer_card_id") String customerCardId, @JsonProperty(value="delay_capture") Boolean delayCapture, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="buyer_email_address") String buyerEmailAddress, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="additional_recipients") List<ChargeRequestAdditionalRecipient> additionalRecipients, @JsonProperty(value="verification_token") String verificationToken) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.cardNonce = OptionalNullable.of((Object)cardNonce);
        this.customerCardId = OptionalNullable.of((Object)customerCardId);
        this.delayCapture = OptionalNullable.of((Object)delayCapture);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.note = OptionalNullable.of((Object)note);
        this.customerId = OptionalNullable.of((Object)customerId);
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.buyerEmailAddress = OptionalNullable.of((Object)buyerEmailAddress);
        this.orderId = OptionalNullable.of((Object)orderId);
        this.additionalRecipients = OptionalNullable.of(additionalRecipients);
        this.verificationToken = OptionalNullable.of((Object)verificationToken);
    }

    protected ChargeRequest(String idempotencyKey, Money amountMoney, OptionalNullable<String> cardNonce, OptionalNullable<String> customerCardId, OptionalNullable<Boolean> delayCapture, OptionalNullable<String> referenceId, OptionalNullable<String> note, OptionalNullable<String> customerId, Address billingAddress, Address shippingAddress, OptionalNullable<String> buyerEmailAddress, OptionalNullable<String> orderId, OptionalNullable<List<ChargeRequestAdditionalRecipient>> additionalRecipients, OptionalNullable<String> verificationToken) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.cardNonce = cardNonce;
        this.customerCardId = customerCardId;
        this.delayCapture = delayCapture;
        this.referenceId = referenceId;
        this.note = note;
        this.customerId = customerId;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.buyerEmailAddress = buyerEmailAddress;
        this.orderId = orderId;
        this.additionalRecipients = additionalRecipients;
        this.verificationToken = verificationToken;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="card_nonce")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCardNonce() {
        return this.cardNonce;
    }

    @JsonIgnore
    public String getCardNonce() {
        return (String)OptionalNullable.getFrom(this.cardNonce);
    }

    @JsonGetter(value="customer_card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerCardId() {
        return this.customerCardId;
    }

    @JsonIgnore
    public String getCustomerCardId() {
        return (String)OptionalNullable.getFrom(this.customerCardId);
    }

    @JsonGetter(value="delay_capture")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetDelayCapture() {
        return this.delayCapture;
    }

    @JsonIgnore
    public Boolean getDelayCapture() {
        return (Boolean)OptionalNullable.getFrom(this.delayCapture);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="buyer_email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonIgnore
    public String getBuyerEmailAddress() {
        return (String)OptionalNullable.getFrom(this.buyerEmailAddress);
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<ChargeRequestAdditionalRecipient>> internalGetAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonIgnore
    public List<ChargeRequestAdditionalRecipient> getAdditionalRecipients() {
        return (List)OptionalNullable.getFrom(this.additionalRecipients);
    }

    @JsonGetter(value="verification_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetVerificationToken() {
        return this.verificationToken;
    }

    @JsonIgnore
    public String getVerificationToken() {
        return (String)OptionalNullable.getFrom(this.verificationToken);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.cardNonce, this.customerCardId, this.delayCapture, this.referenceId, this.note, this.customerId, this.billingAddress, this.shippingAddress, this.buyerEmailAddress, this.orderId, this.additionalRecipients, this.verificationToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChargeRequest)) {
            return false;
        }
        ChargeRequest other = (ChargeRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.cardNonce, other.cardNonce) && Objects.equals(this.customerCardId, other.customerCardId) && Objects.equals(this.delayCapture, other.delayCapture) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.buyerEmailAddress, other.buyerEmailAddress) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.additionalRecipients, other.additionalRecipients) && Objects.equals(this.verificationToken, other.verificationToken);
    }

    public String toString() {
        return "ChargeRequest [idempotencyKey=" + this.idempotencyKey + ", amountMoney=" + this.amountMoney + ", cardNonce=" + this.cardNonce + ", customerCardId=" + this.customerCardId + ", delayCapture=" + this.delayCapture + ", referenceId=" + this.referenceId + ", note=" + this.note + ", customerId=" + this.customerId + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", buyerEmailAddress=" + this.buyerEmailAddress + ", orderId=" + this.orderId + ", additionalRecipients=" + this.additionalRecipients + ", verificationToken=" + this.verificationToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.amountMoney).billingAddress(this.getBillingAddress()).shippingAddress(this.getShippingAddress());
        builder.cardNonce = this.internalGetCardNonce();
        builder.customerCardId = this.internalGetCustomerCardId();
        builder.delayCapture = this.internalGetDelayCapture();
        builder.referenceId = this.internalGetReferenceId();
        builder.note = this.internalGetNote();
        builder.customerId = this.internalGetCustomerId();
        builder.buyerEmailAddress = this.internalGetBuyerEmailAddress();
        builder.orderId = this.internalGetOrderId();
        builder.additionalRecipients = this.internalGetAdditionalRecipients();
        builder.verificationToken = this.internalGetVerificationToken();
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Money amountMoney;
        private OptionalNullable<String> cardNonce;
        private OptionalNullable<String> customerCardId;
        private OptionalNullable<Boolean> delayCapture;
        private OptionalNullable<String> referenceId;
        private OptionalNullable<String> note;
        private OptionalNullable<String> customerId;
        private Address billingAddress;
        private Address shippingAddress;
        private OptionalNullable<String> buyerEmailAddress;
        private OptionalNullable<String> orderId;
        private OptionalNullable<List<ChargeRequestAdditionalRecipient>> additionalRecipients;
        private OptionalNullable<String> verificationToken;

        public Builder(String idempotencyKey, Money amountMoney) {
            this.idempotencyKey = idempotencyKey;
            this.amountMoney = amountMoney;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder cardNonce(String cardNonce) {
            this.cardNonce = OptionalNullable.of((Object)cardNonce);
            return this;
        }

        public Builder unsetCardNonce() {
            this.cardNonce = null;
            return this;
        }

        public Builder customerCardId(String customerCardId) {
            this.customerCardId = OptionalNullable.of((Object)customerCardId);
            return this;
        }

        public Builder unsetCustomerCardId() {
            this.customerCardId = null;
            return this;
        }

        public Builder delayCapture(Boolean delayCapture) {
            this.delayCapture = OptionalNullable.of((Object)delayCapture);
            return this;
        }

        public Builder unsetDelayCapture() {
            this.delayCapture = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = OptionalNullable.of((Object)buyerEmailAddress);
            return this;
        }

        public Builder unsetBuyerEmailAddress() {
            this.buyerEmailAddress = null;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder additionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = OptionalNullable.of(additionalRecipients);
            return this;
        }

        public Builder unsetAdditionalRecipients() {
            this.additionalRecipients = null;
            return this;
        }

        public Builder verificationToken(String verificationToken) {
            this.verificationToken = OptionalNullable.of((Object)verificationToken);
            return this;
        }

        public Builder unsetVerificationToken() {
            this.verificationToken = null;
            return this;
        }

        public ChargeRequest build() {
            return new ChargeRequest(this.idempotencyKey, this.amountMoney, this.cardNonce, this.customerCardId, this.delayCapture, this.referenceId, this.note, this.customerId, this.billingAddress, this.shippingAddress, this.buyerEmailAddress, this.orderId, this.additionalRecipients, this.verificationToken);
        }
    }
}

