/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.ConfirmationDecision;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ConfirmationOptions {
    private final String title;
    private final String body;
    private final String agreeButtonText;
    private final OptionalNullable<String> disagreeButtonText;
    private final ConfirmationDecision decision;

    @JsonCreator
    public ConfirmationOptions(@JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="agree_button_text") String agreeButtonText, @JsonProperty(value="disagree_button_text") String disagreeButtonText, @JsonProperty(value="decision") ConfirmationDecision decision) {
        this.title = title;
        this.body = body;
        this.agreeButtonText = agreeButtonText;
        this.disagreeButtonText = OptionalNullable.of((Object)disagreeButtonText);
        this.decision = decision;
    }

    protected ConfirmationOptions(String title, String body, String agreeButtonText, OptionalNullable<String> disagreeButtonText, ConfirmationDecision decision) {
        this.title = title;
        this.body = body;
        this.agreeButtonText = agreeButtonText;
        this.disagreeButtonText = disagreeButtonText;
        this.decision = decision;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonGetter(value="agree_button_text")
    public String getAgreeButtonText() {
        return this.agreeButtonText;
    }

    @JsonGetter(value="disagree_button_text")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDisagreeButtonText() {
        return this.disagreeButtonText;
    }

    @JsonIgnore
    public String getDisagreeButtonText() {
        return (String)OptionalNullable.getFrom(this.disagreeButtonText);
    }

    @JsonGetter(value="decision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ConfirmationDecision getDecision() {
        return this.decision;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.agreeButtonText, this.disagreeButtonText, this.decision);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConfirmationOptions)) {
            return false;
        }
        ConfirmationOptions other = (ConfirmationOptions)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.agreeButtonText, other.agreeButtonText) && Objects.equals(this.disagreeButtonText, other.disagreeButtonText) && Objects.equals(this.decision, other.decision);
    }

    public String toString() {
        return "ConfirmationOptions [title=" + this.title + ", body=" + this.body + ", agreeButtonText=" + this.agreeButtonText + ", disagreeButtonText=" + this.disagreeButtonText + ", decision=" + this.decision + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.title, this.body, this.agreeButtonText).decision(this.getDecision());
        builder.disagreeButtonText = this.internalGetDisagreeButtonText();
        return builder;
    }

    public static class Builder {
        private String title;
        private String body;
        private String agreeButtonText;
        private OptionalNullable<String> disagreeButtonText;
        private ConfirmationDecision decision;

        public Builder(String title, String body, String agreeButtonText) {
            this.title = title;
            this.body = body;
            this.agreeButtonText = agreeButtonText;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder agreeButtonText(String agreeButtonText) {
            this.agreeButtonText = agreeButtonText;
            return this;
        }

        public Builder disagreeButtonText(String disagreeButtonText) {
            this.disagreeButtonText = OptionalNullable.of((Object)disagreeButtonText);
            return this;
        }

        public Builder unsetDisagreeButtonText() {
            this.disagreeButtonText = null;
            return this;
        }

        public Builder decision(ConfirmationDecision decision) {
            this.decision = decision;
            return this;
        }

        public ConfirmationOptions build() {
            return new ConfirmationOptions(this.title, this.body, this.agreeButtonText, this.disagreeButtonText, this.decision);
        }
    }
}

