/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.BreakType;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CreateBreakTypeResponse {
    private HttpContext httpContext;
    private final BreakType breakType;
    private final List<Error> errors;

    @JsonCreator
    public CreateBreakTypeResponse(@JsonProperty(value="break_type") BreakType breakType, @JsonProperty(value="errors") List<Error> errors) {
        this.breakType = breakType;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="break_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BreakType getBreakType() {
        return this.breakType;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.breakType, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateBreakTypeResponse)) {
            return false;
        }
        CreateBreakTypeResponse other = (CreateBreakTypeResponse)obj;
        return Objects.equals(this.breakType, other.breakType) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "CreateBreakTypeResponse [breakType=" + this.breakType + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().breakType(this.getBreakType()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private BreakType breakType;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder breakType(BreakType breakType) {
            this.breakType = breakType;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public CreateBreakTypeResponse build() {
            CreateBreakTypeResponse model = new CreateBreakTypeResponse(this.breakType, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

