/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.ChargeRequestAdditionalRecipient;
import com.squareup.square.models.CreateOrderRequest;
import java.util.List;
import java.util.Objects;

public class CreateCheckoutRequest {
    private final String idempotencyKey;
    private final CreateOrderRequest order;
    private final Boolean askForShippingAddress;
    private final String merchantSupportEmail;
    private final String prePopulateBuyerEmail;
    private final Address prePopulateShippingAddress;
    private final String redirectUrl;
    private final List<ChargeRequestAdditionalRecipient> additionalRecipients;
    private final String note;

    @JsonCreator
    public CreateCheckoutRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="order") CreateOrderRequest order, @JsonProperty(value="ask_for_shipping_address") Boolean askForShippingAddress, @JsonProperty(value="merchant_support_email") String merchantSupportEmail, @JsonProperty(value="pre_populate_buyer_email") String prePopulateBuyerEmail, @JsonProperty(value="pre_populate_shipping_address") Address prePopulateShippingAddress, @JsonProperty(value="redirect_url") String redirectUrl, @JsonProperty(value="additional_recipients") List<ChargeRequestAdditionalRecipient> additionalRecipients, @JsonProperty(value="note") String note) {
        this.idempotencyKey = idempotencyKey;
        this.order = order;
        this.askForShippingAddress = askForShippingAddress;
        this.merchantSupportEmail = merchantSupportEmail;
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        this.redirectUrl = redirectUrl;
        this.additionalRecipients = additionalRecipients;
        this.note = note;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="order")
    public CreateOrderRequest getOrder() {
        return this.order;
    }

    @JsonGetter(value="ask_for_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonGetter(value="merchant_support_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonGetter(value="pre_populate_buyer_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    @JsonGetter(value="pre_populate_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    @JsonGetter(value="redirect_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ChargeRequestAdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.order, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.additionalRecipients, this.note);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCheckoutRequest)) {
            return false;
        }
        CreateCheckoutRequest other = (CreateCheckoutRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.order, other.order) && Objects.equals(this.askForShippingAddress, other.askForShippingAddress) && Objects.equals(this.merchantSupportEmail, other.merchantSupportEmail) && Objects.equals(this.prePopulateBuyerEmail, other.prePopulateBuyerEmail) && Objects.equals(this.prePopulateShippingAddress, other.prePopulateShippingAddress) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals(this.additionalRecipients, other.additionalRecipients) && Objects.equals(this.note, other.note);
    }

    public String toString() {
        return "CreateCheckoutRequest [idempotencyKey=" + this.idempotencyKey + ", order=" + this.order + ", askForShippingAddress=" + this.askForShippingAddress + ", merchantSupportEmail=" + this.merchantSupportEmail + ", prePopulateBuyerEmail=" + this.prePopulateBuyerEmail + ", prePopulateShippingAddress=" + this.prePopulateShippingAddress + ", redirectUrl=" + this.redirectUrl + ", additionalRecipients=" + this.additionalRecipients + ", note=" + this.note + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.order).askForShippingAddress(this.getAskForShippingAddress()).merchantSupportEmail(this.getMerchantSupportEmail()).prePopulateBuyerEmail(this.getPrePopulateBuyerEmail()).prePopulateShippingAddress(this.getPrePopulateShippingAddress()).redirectUrl(this.getRedirectUrl()).additionalRecipients(this.getAdditionalRecipients()).note(this.getNote());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private CreateOrderRequest order;
        private Boolean askForShippingAddress;
        private String merchantSupportEmail;
        private String prePopulateBuyerEmail;
        private Address prePopulateShippingAddress;
        private String redirectUrl;
        private List<ChargeRequestAdditionalRecipient> additionalRecipients;
        private String note;

        public Builder(String idempotencyKey, CreateOrderRequest order) {
            this.idempotencyKey = idempotencyKey;
            this.order = order;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder order(CreateOrderRequest order) {
            this.order = order;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        public Builder prePopulateBuyerEmail(String prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = prePopulateBuyerEmail;
            return this;
        }

        public Builder prePopulateShippingAddress(Address prePopulateShippingAddress) {
            this.prePopulateShippingAddress = prePopulateShippingAddress;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder additionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public CreateCheckoutRequest build() {
            return new CreateCheckoutRequest(this.idempotencyKey, this.order, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.additionalRecipients, this.note);
        }
    }
}

