/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.GiftCardActivity;
import java.util.List;
import java.util.Objects;

public class CreateGiftCardActivityResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final GiftCardActivity giftCardActivity;

    @JsonCreator
    public CreateGiftCardActivityResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="gift_card_activity") GiftCardActivity giftCardActivity) {
        this.errors = errors;
        this.giftCardActivity = giftCardActivity;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="gift_card_activity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GiftCardActivity getGiftCardActivity() {
        return this.giftCardActivity;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.giftCardActivity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateGiftCardActivityResponse)) {
            return false;
        }
        CreateGiftCardActivityResponse other = (CreateGiftCardActivityResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.giftCardActivity, other.giftCardActivity);
    }

    public String toString() {
        return "CreateGiftCardActivityResponse [errors=" + this.errors + ", giftCardActivity=" + this.giftCardActivity + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).giftCardActivity(this.getGiftCardActivity());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private GiftCardActivity giftCardActivity;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder giftCardActivity(GiftCardActivity giftCardActivity) {
            this.giftCardActivity = giftCardActivity;
            return this;
        }

        public CreateGiftCardActivityResponse build() {
            CreateGiftCardActivityResponse model = new CreateGiftCardActivityResponse(this.errors, this.giftCardActivity);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

