/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyPromotion;
import java.util.Objects;

public class CreateLoyaltyPromotionRequest {
    private final LoyaltyPromotion loyaltyPromotion;
    private final String idempotencyKey;

    @JsonCreator
    public CreateLoyaltyPromotionRequest(@JsonProperty(value="loyalty_promotion") LoyaltyPromotion loyaltyPromotion, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.loyaltyPromotion = loyaltyPromotion;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="loyalty_promotion")
    public LoyaltyPromotion getLoyaltyPromotion() {
        return this.loyaltyPromotion;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyPromotion, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateLoyaltyPromotionRequest)) {
            return false;
        }
        CreateLoyaltyPromotionRequest other = (CreateLoyaltyPromotionRequest)obj;
        return Objects.equals(this.loyaltyPromotion, other.loyaltyPromotion) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateLoyaltyPromotionRequest [loyaltyPromotion=" + this.loyaltyPromotion + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyPromotion, this.idempotencyKey);
        return builder;
    }

    public static class Builder {
        private LoyaltyPromotion loyaltyPromotion;
        private String idempotencyKey;

        public Builder(LoyaltyPromotion loyaltyPromotion, String idempotencyKey) {
            this.loyaltyPromotion = loyaltyPromotion;
            this.idempotencyKey = idempotencyKey;
        }

        public Builder loyaltyPromotion(LoyaltyPromotion loyaltyPromotion) {
            this.loyaltyPromotion = loyaltyPromotion;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateLoyaltyPromotionRequest build() {
            return new CreateLoyaltyPromotionRequest(this.loyaltyPromotion, this.idempotencyKey);
        }
    }
}

