/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttributeDefinition;
import java.util.Objects;

public class CreateOrderCustomAttributeDefinitionRequest {
    private final CustomAttributeDefinition customAttributeDefinition;
    private final String idempotencyKey;

    @JsonCreator
    public CreateOrderCustomAttributeDefinitionRequest(@JsonProperty(value="custom_attribute_definition") CustomAttributeDefinition customAttributeDefinition, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customAttributeDefinition = customAttributeDefinition;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="custom_attribute_definition")
    public CustomAttributeDefinition getCustomAttributeDefinition() {
        return this.customAttributeDefinition;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.customAttributeDefinition, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateOrderCustomAttributeDefinitionRequest)) {
            return false;
        }
        CreateOrderCustomAttributeDefinitionRequest other = (CreateOrderCustomAttributeDefinitionRequest)obj;
        return Objects.equals(this.customAttributeDefinition, other.customAttributeDefinition) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateOrderCustomAttributeDefinitionRequest [customAttributeDefinition=" + this.customAttributeDefinition + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customAttributeDefinition).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private CustomAttributeDefinition customAttributeDefinition;
        private String idempotencyKey;

        public Builder(CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = customAttributeDefinition;
        }

        public Builder customAttributeDefinition(CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = customAttributeDefinition;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOrderCustomAttributeDefinitionRequest build() {
            return new CreateOrderCustomAttributeDefinitionRequest(this.customAttributeDefinition, this.idempotencyKey);
        }
    }
}

