/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Error;
import com.squareup.square.models.Refund;
import java.util.List;
import java.util.Objects;

public class CreateRefundResponse {
    private final List<Error> errors;
    private final Refund refund;

    @JsonCreator
    public CreateRefundResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="refund") Refund refund) {
        this.errors = errors;
        this.refund = refund;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="refund")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Refund getRefund() {
        return this.refund;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refund);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateRefundResponse)) {
            return false;
        }
        CreateRefundResponse other = (CreateRefundResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.refund, other.refund);
    }

    public String toString() {
        return "CreateRefundResponse [errors=" + this.errors + ", refund=" + this.refund + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).refund(this.getRefund());
        return builder;
    }

    public static class Builder {
        private List<Error> errors;
        private Refund refund;

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder refund(Refund refund) {
            this.refund = refund;
            return this;
        }

        public CreateRefundResponse build() {
            return new CreateRefundResponse(this.errors, this.refund);
        }
    }
}

