/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.Phase;
import com.squareup.square.models.SubscriptionSource;
import java.util.List;
import java.util.Objects;

public class CreateSubscriptionRequest {
    private final String idempotencyKey;
    private final String locationId;
    private final String planId;
    private final String planVariationId;
    private final String customerId;
    private final String startDate;
    private final String canceledDate;
    private final String taxPercentage;
    private final Money priceOverrideMoney;
    private final String cardId;
    private final String timezone;
    private final SubscriptionSource source;
    private final List<Phase> phases;

    @JsonCreator
    public CreateSubscriptionRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="plan_id") String planId, @JsonProperty(value="plan_variation_id") String planVariationId, @JsonProperty(value="start_date") String startDate, @JsonProperty(value="canceled_date") String canceledDate, @JsonProperty(value="tax_percentage") String taxPercentage, @JsonProperty(value="price_override_money") Money priceOverrideMoney, @JsonProperty(value="card_id") String cardId, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="source") SubscriptionSource source, @JsonProperty(value="phases") List<Phase> phases) {
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.planId = planId;
        this.planVariationId = planVariationId;
        this.customerId = customerId;
        this.startDate = startDate;
        this.canceledDate = canceledDate;
        this.taxPercentage = taxPercentage;
        this.priceOverrideMoney = priceOverrideMoney;
        this.cardId = cardId;
        this.timezone = timezone;
        this.source = source;
        this.phases = phases;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlanId() {
        return this.planId;
    }

    @JsonGetter(value="plan_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlanVariationId() {
        return this.planVariationId;
    }

    @JsonGetter(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonGetter(value="canceled_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledDate() {
        return this.canceledDate;
    }

    @JsonGetter(value="tax_percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTaxPercentage() {
        return this.taxPercentage;
    }

    @JsonGetter(value="price_override_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceOverrideMoney() {
        return this.priceOverrideMoney;
    }

    @JsonGetter(value="card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardId() {
        return this.cardId;
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionSource getSource() {
        return this.source;
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Phase> getPhases() {
        return this.phases;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.locationId, this.planId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.taxPercentage, this.priceOverrideMoney, this.cardId, this.timezone, this.source, this.phases);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateSubscriptionRequest)) {
            return false;
        }
        CreateSubscriptionRequest other = (CreateSubscriptionRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.planId, other.planId) && Objects.equals(this.planVariationId, other.planVariationId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.canceledDate, other.canceledDate) && Objects.equals(this.taxPercentage, other.taxPercentage) && Objects.equals(this.priceOverrideMoney, other.priceOverrideMoney) && Objects.equals(this.cardId, other.cardId) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.source, other.source) && Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return "CreateSubscriptionRequest [locationId=" + this.locationId + ", customerId=" + this.customerId + ", idempotencyKey=" + this.idempotencyKey + ", planId=" + this.planId + ", planVariationId=" + this.planVariationId + ", startDate=" + this.startDate + ", canceledDate=" + this.canceledDate + ", taxPercentage=" + this.taxPercentage + ", priceOverrideMoney=" + this.priceOverrideMoney + ", cardId=" + this.cardId + ", timezone=" + this.timezone + ", source=" + this.source + ", phases=" + this.phases + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.customerId).idempotencyKey(this.getIdempotencyKey()).planId(this.getPlanId()).planVariationId(this.getPlanVariationId()).startDate(this.getStartDate()).canceledDate(this.getCanceledDate()).taxPercentage(this.getTaxPercentage()).priceOverrideMoney(this.getPriceOverrideMoney()).cardId(this.getCardId()).timezone(this.getTimezone()).source(this.getSource()).phases(this.getPhases());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String customerId;
        private String idempotencyKey;
        private String planId;
        private String planVariationId;
        private String startDate;
        private String canceledDate;
        private String taxPercentage;
        private Money priceOverrideMoney;
        private String cardId;
        private String timezone;
        private SubscriptionSource source;
        private List<Phase> phases;

        public Builder(String locationId, String customerId) {
            this.locationId = locationId;
            this.customerId = customerId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public Builder planVariationId(String planVariationId) {
            this.planVariationId = planVariationId;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder canceledDate(String canceledDate) {
            this.canceledDate = canceledDate;
            return this;
        }

        public Builder taxPercentage(String taxPercentage) {
            this.taxPercentage = taxPercentage;
            return this;
        }

        public Builder priceOverrideMoney(Money priceOverrideMoney) {
            this.priceOverrideMoney = priceOverrideMoney;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder source(SubscriptionSource source) {
            this.source = source;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = phases;
            return this;
        }

        public CreateSubscriptionRequest build() {
            return new CreateSubscriptionRequest(this.locationId, this.customerId, this.idempotencyKey, this.planId, this.planVariationId, this.startDate, this.canceledDate, this.taxPercentage, this.priceOverrideMoney, this.cardId, this.timezone, this.source, this.phases);
        }
    }
}

