/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TerminalRefund;
import java.util.List;
import java.util.Objects;

public class CreateTerminalRefundResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final TerminalRefund refund;

    @JsonCreator
    public CreateTerminalRefundResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="refund") TerminalRefund refund) {
        this.errors = errors;
        this.refund = refund;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="refund")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TerminalRefund getRefund() {
        return this.refund;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refund);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateTerminalRefundResponse)) {
            return false;
        }
        CreateTerminalRefundResponse other = (CreateTerminalRefundResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.refund, other.refund);
    }

    public String toString() {
        return "CreateTerminalRefundResponse [errors=" + this.errors + ", refund=" + this.refund + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).refund(this.getRefund());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private TerminalRefund refund;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder refund(TerminalRefund refund) {
            this.refund = refund;
            return this;
        }

        public CreateTerminalRefundResponse build() {
            CreateTerminalRefundResponse model = new CreateTerminalRefundResponse(this.errors, this.refund);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

