/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.WebhookSubscription;
import java.util.Objects;

public class CreateWebhookSubscriptionRequest {
    private final String idempotencyKey;
    private final WebhookSubscription subscription;

    @JsonCreator
    public CreateWebhookSubscriptionRequest(@JsonProperty(value="subscription") WebhookSubscription subscription, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.subscription = subscription;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="subscription")
    public WebhookSubscription getSubscription() {
        return this.subscription;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.subscription);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateWebhookSubscriptionRequest)) {
            return false;
        }
        CreateWebhookSubscriptionRequest other = (CreateWebhookSubscriptionRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.subscription, other.subscription);
    }

    public String toString() {
        return "CreateWebhookSubscriptionRequest [subscription=" + this.subscription + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.subscription).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private WebhookSubscription subscription;
        private String idempotencyKey;

        public Builder(WebhookSubscription subscription) {
            this.subscription = subscription;
        }

        public Builder subscription(WebhookSubscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateWebhookSubscriptionRequest build() {
            return new CreateWebhookSubscriptionRequest(this.subscription, this.idempotencyKey);
        }
    }
}

