/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.WebhookSubscription;
import java.util.List;
import java.util.Objects;

public class CreateWebhookSubscriptionResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final WebhookSubscription subscription;

    @JsonCreator
    public CreateWebhookSubscriptionResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="subscription") WebhookSubscription subscription) {
        this.errors = errors;
        this.subscription = subscription;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="subscription")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public WebhookSubscription getSubscription() {
        return this.subscription;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscription);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateWebhookSubscriptionResponse)) {
            return false;
        }
        CreateWebhookSubscriptionResponse other = (CreateWebhookSubscriptionResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.subscription, other.subscription);
    }

    public String toString() {
        return "CreateWebhookSubscriptionResponse [errors=" + this.errors + ", subscription=" + this.subscription + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).subscription(this.getSubscription());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private WebhookSubscription subscription;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder subscription(WebhookSubscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public CreateWebhookSubscriptionResponse build() {
            CreateWebhookSubscriptionResponse model = new CreateWebhookSubscriptionResponse(this.errors, this.subscription);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

