/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import com.squareup.square.models.Card;
import com.squareup.square.models.CustomerPreferences;
import com.squareup.square.models.CustomerTaxIds;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Customer {
    private final String id;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<List<Card>> cards;
    private final OptionalNullable<String> givenName;
    private final OptionalNullable<String> familyName;
    private final OptionalNullable<String> nickname;
    private final OptionalNullable<String> companyName;
    private final OptionalNullable<String> emailAddress;
    private final Address address;
    private final OptionalNullable<String> phoneNumber;
    private final OptionalNullable<String> birthday;
    private final OptionalNullable<String> referenceId;
    private final OptionalNullable<String> note;
    private final CustomerPreferences preferences;
    private final String creationSource;
    private final OptionalNullable<List<String>> groupIds;
    private final OptionalNullable<List<String>> segmentIds;
    private final Long version;
    private final CustomerTaxIds taxIds;

    @JsonCreator
    public Customer(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="cards") List<Card> cards, @JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="nickname") String nickname, @JsonProperty(value="company_name") String companyName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="address") Address address, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="birthday") String birthday, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="preferences") CustomerPreferences preferences, @JsonProperty(value="creation_source") String creationSource, @JsonProperty(value="group_ids") List<String> groupIds, @JsonProperty(value="segment_ids") List<String> segmentIds, @JsonProperty(value="version") Long version, @JsonProperty(value="tax_ids") CustomerTaxIds taxIds) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.cards = OptionalNullable.of(cards);
        this.givenName = OptionalNullable.of((Object)givenName);
        this.familyName = OptionalNullable.of((Object)familyName);
        this.nickname = OptionalNullable.of((Object)nickname);
        this.companyName = OptionalNullable.of((Object)companyName);
        this.emailAddress = OptionalNullable.of((Object)emailAddress);
        this.address = address;
        this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
        this.birthday = OptionalNullable.of((Object)birthday);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.note = OptionalNullable.of((Object)note);
        this.preferences = preferences;
        this.creationSource = creationSource;
        this.groupIds = OptionalNullable.of(groupIds);
        this.segmentIds = OptionalNullable.of(segmentIds);
        this.version = version;
        this.taxIds = taxIds;
    }

    protected Customer(String id, String createdAt, String updatedAt, OptionalNullable<List<Card>> cards, OptionalNullable<String> givenName, OptionalNullable<String> familyName, OptionalNullable<String> nickname, OptionalNullable<String> companyName, OptionalNullable<String> emailAddress, Address address, OptionalNullable<String> phoneNumber, OptionalNullable<String> birthday, OptionalNullable<String> referenceId, OptionalNullable<String> note, CustomerPreferences preferences, String creationSource, OptionalNullable<List<String>> groupIds, OptionalNullable<List<String>> segmentIds, Long version, CustomerTaxIds taxIds) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.cards = cards;
        this.givenName = givenName;
        this.familyName = familyName;
        this.nickname = nickname;
        this.companyName = companyName;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.birthday = birthday;
        this.referenceId = referenceId;
        this.note = note;
        this.preferences = preferences;
        this.creationSource = creationSource;
        this.groupIds = groupIds;
        this.segmentIds = segmentIds;
        this.version = version;
        this.taxIds = taxIds;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="cards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Card>> internalGetCards() {
        return this.cards;
    }

    @JsonIgnore
    public List<Card> getCards() {
        return (List)OptionalNullable.getFrom(this.cards);
    }

    @JsonGetter(value="given_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetGivenName() {
        return this.givenName;
    }

    @JsonIgnore
    public String getGivenName() {
        return (String)OptionalNullable.getFrom(this.givenName);
    }

    @JsonGetter(value="family_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFamilyName() {
        return this.familyName;
    }

    @JsonIgnore
    public String getFamilyName() {
        return (String)OptionalNullable.getFrom(this.familyName);
    }

    @JsonGetter(value="nickname")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNickname() {
        return this.nickname;
    }

    @JsonIgnore
    public String getNickname() {
        return (String)OptionalNullable.getFrom(this.nickname);
    }

    @JsonGetter(value="company_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCompanyName() {
        return this.companyName;
    }

    @JsonIgnore
    public String getCompanyName() {
        return (String)OptionalNullable.getFrom(this.companyName);
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String getEmailAddress() {
        return (String)OptionalNullable.getFrom(this.emailAddress);
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.phoneNumber);
    }

    @JsonGetter(value="birthday")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBirthday() {
        return this.birthday;
    }

    @JsonIgnore
    public String getBirthday() {
        return (String)OptionalNullable.getFrom(this.birthday);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="preferences")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerPreferences getPreferences() {
        return this.preferences;
    }

    @JsonGetter(value="creation_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreationSource() {
        return this.creationSource;
    }

    @JsonGetter(value="group_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetGroupIds() {
        return this.groupIds;
    }

    @JsonIgnore
    public List<String> getGroupIds() {
        return (List)OptionalNullable.getFrom(this.groupIds);
    }

    @JsonGetter(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetSegmentIds() {
        return this.segmentIds;
    }

    @JsonIgnore
    public List<String> getSegmentIds() {
        return (List)OptionalNullable.getFrom(this.segmentIds);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    @JsonGetter(value="tax_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTaxIds getTaxIds() {
        return this.taxIds;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.cards, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.cards, other.cards) && Objects.equals(this.givenName, other.givenName) && Objects.equals(this.familyName, other.familyName) && Objects.equals(this.nickname, other.nickname) && Objects.equals(this.companyName, other.companyName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.address, other.address) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.birthday, other.birthday) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.preferences, other.preferences) && Objects.equals(this.creationSource, other.creationSource) && Objects.equals(this.groupIds, other.groupIds) && Objects.equals(this.segmentIds, other.segmentIds) && Objects.equals(this.version, other.version) && Objects.equals(this.taxIds, other.taxIds);
    }

    public String toString() {
        return "Customer [id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", cards=" + this.cards + ", givenName=" + this.givenName + ", familyName=" + this.familyName + ", nickname=" + this.nickname + ", companyName=" + this.companyName + ", emailAddress=" + this.emailAddress + ", address=" + this.address + ", phoneNumber=" + this.phoneNumber + ", birthday=" + this.birthday + ", referenceId=" + this.referenceId + ", note=" + this.note + ", preferences=" + this.preferences + ", creationSource=" + this.creationSource + ", groupIds=" + this.groupIds + ", segmentIds=" + this.segmentIds + ", version=" + this.version + ", taxIds=" + this.taxIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).address(this.getAddress()).preferences(this.getPreferences()).creationSource(this.getCreationSource()).version(this.getVersion()).taxIds(this.getTaxIds());
        builder.cards = this.internalGetCards();
        builder.givenName = this.internalGetGivenName();
        builder.familyName = this.internalGetFamilyName();
        builder.nickname = this.internalGetNickname();
        builder.companyName = this.internalGetCompanyName();
        builder.emailAddress = this.internalGetEmailAddress();
        builder.phoneNumber = this.internalGetPhoneNumber();
        builder.birthday = this.internalGetBirthday();
        builder.referenceId = this.internalGetReferenceId();
        builder.note = this.internalGetNote();
        builder.groupIds = this.internalGetGroupIds();
        builder.segmentIds = this.internalGetSegmentIds();
        return builder;
    }

    public static class Builder {
        private String id;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<List<Card>> cards;
        private OptionalNullable<String> givenName;
        private OptionalNullable<String> familyName;
        private OptionalNullable<String> nickname;
        private OptionalNullable<String> companyName;
        private OptionalNullable<String> emailAddress;
        private Address address;
        private OptionalNullable<String> phoneNumber;
        private OptionalNullable<String> birthday;
        private OptionalNullable<String> referenceId;
        private OptionalNullable<String> note;
        private CustomerPreferences preferences;
        private String creationSource;
        private OptionalNullable<List<String>> groupIds;
        private OptionalNullable<List<String>> segmentIds;
        private Long version;
        private CustomerTaxIds taxIds;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder cards(List<Card> cards) {
            this.cards = OptionalNullable.of(cards);
            return this;
        }

        public Builder unsetCards() {
            this.cards = null;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = OptionalNullable.of((Object)givenName);
            return this;
        }

        public Builder unsetGivenName() {
            this.givenName = null;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = OptionalNullable.of((Object)familyName);
            return this;
        }

        public Builder unsetFamilyName() {
            this.familyName = null;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = OptionalNullable.of((Object)nickname);
            return this;
        }

        public Builder unsetNickname() {
            this.nickname = null;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = OptionalNullable.of((Object)companyName);
            return this;
        }

        public Builder unsetCompanyName() {
            this.companyName = null;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = OptionalNullable.of((Object)emailAddress);
            return this;
        }

        public Builder unsetEmailAddress() {
            this.emailAddress = null;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
            return this;
        }

        public Builder unsetPhoneNumber() {
            this.phoneNumber = null;
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = OptionalNullable.of((Object)birthday);
            return this;
        }

        public Builder unsetBirthday() {
            this.birthday = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder preferences(CustomerPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        public Builder creationSource(String creationSource) {
            this.creationSource = creationSource;
            return this;
        }

        public Builder groupIds(List<String> groupIds) {
            this.groupIds = OptionalNullable.of(groupIds);
            return this;
        }

        public Builder unsetGroupIds() {
            this.groupIds = null;
            return this;
        }

        public Builder segmentIds(List<String> segmentIds) {
            this.segmentIds = OptionalNullable.of(segmentIds);
            return this;
        }

        public Builder unsetSegmentIds() {
            this.segmentIds = null;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder taxIds(CustomerTaxIds taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Customer build() {
            return new Customer(this.id, this.createdAt, this.updatedAt, this.cards, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds);
        }
    }
}

