/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerTextFilter;
import java.util.Objects;

public class CustomerAddressFilter {
    private final CustomerTextFilter postalCode;
    private final String country;

    @JsonCreator
    public CustomerAddressFilter(@JsonProperty(value="postal_code") CustomerTextFilter postalCode, @JsonProperty(value="country") String country) {
        this.postalCode = postalCode;
        this.country = country;
    }

    @JsonGetter(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getPostalCode() {
        return this.postalCode;
    }

    @JsonGetter(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCountry() {
        return this.country;
    }

    public int hashCode() {
        return Objects.hash(this.postalCode, this.country);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerAddressFilter)) {
            return false;
        }
        CustomerAddressFilter other = (CustomerAddressFilter)obj;
        return Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.country, other.country);
    }

    public String toString() {
        return "CustomerAddressFilter [postalCode=" + this.postalCode + ", country=" + this.country + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().postalCode(this.getPostalCode()).country(this.getCountry());
        return builder;
    }

    public static class Builder {
        private CustomerTextFilter postalCode;
        private String country;

        public Builder postalCode(CustomerTextFilter postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public CustomerAddressFilter build() {
            return new CustomerAddressFilter(this.postalCode, this.country);
        }
    }
}

