/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerCustomAttributeFilterValue;
import com.squareup.square.models.TimeRange;
import java.util.Objects;

public class CustomerCustomAttributeFilter {
    private final String key;
    private final CustomerCustomAttributeFilterValue filter;
    private final TimeRange updatedAt;

    @JsonCreator
    public CustomerCustomAttributeFilter(@JsonProperty(value="key") String key, @JsonProperty(value="filter") CustomerCustomAttributeFilterValue filter, @JsonProperty(value="updated_at") TimeRange updatedAt) {
        this.key = key;
        this.filter = filter;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonGetter(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerCustomAttributeFilterValue getFilter() {
        return this.filter;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.filter, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerCustomAttributeFilter)) {
            return false;
        }
        CustomerCustomAttributeFilter other = (CustomerCustomAttributeFilter)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "CustomerCustomAttributeFilter [key=" + this.key + ", filter=" + this.filter + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.key).filter(this.getFilter()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String key;
        private CustomerCustomAttributeFilterValue filter;
        private TimeRange updatedAt;

        public Builder(String key) {
            this.key = key;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder filter(CustomerCustomAttributeFilterValue filter) {
            this.filter = filter;
            return this;
        }

        public Builder updatedAt(TimeRange updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CustomerCustomAttributeFilter build() {
            return new CustomerCustomAttributeFilter(this.key, this.filter, this.updatedAt);
        }
    }
}

