/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CustomerSegment {
    private final String id;
    private final String name;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public CustomerSegment(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerSegment)) {
            return false;
        }
        CustomerSegment other = (CustomerSegment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "CustomerSegment [name=" + this.name + ", id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name).id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String name;
        private String id;
        private String createdAt;
        private String updatedAt;

        public Builder(String name) {
            this.name = name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CustomerSegment build() {
            return new CustomerSegment(this.name, this.id, this.createdAt, this.updatedAt);
        }
    }
}

