/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CollectedData;
import java.util.Objects;

public class DataCollectionOptions {
    private final String title;
    private final String body;
    private final String inputType;
    private final CollectedData collectedData;

    @JsonCreator
    public DataCollectionOptions(@JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="input_type") String inputType, @JsonProperty(value="collected_data") CollectedData collectedData) {
        this.title = title;
        this.body = body;
        this.inputType = inputType;
        this.collectedData = collectedData;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonGetter(value="input_type")
    public String getInputType() {
        return this.inputType;
    }

    @JsonGetter(value="collected_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CollectedData getCollectedData() {
        return this.collectedData;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.inputType, this.collectedData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataCollectionOptions)) {
            return false;
        }
        DataCollectionOptions other = (DataCollectionOptions)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.inputType, other.inputType) && Objects.equals(this.collectedData, other.collectedData);
    }

    public String toString() {
        return "DataCollectionOptions [title=" + this.title + ", body=" + this.body + ", inputType=" + this.inputType + ", collectedData=" + this.collectedData + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.title, this.body, this.inputType).collectedData(this.getCollectedData());
        return builder;
    }

    public static class Builder {
        private String title;
        private String body;
        private String inputType;
        private CollectedData collectedData;

        public Builder(String title, String body, String inputType) {
            this.title = title;
            this.body = body;
            this.inputType = inputType;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder collectedData(CollectedData collectedData) {
            this.collectedData = collectedData;
            return this;
        }

        public DataCollectionOptions build() {
            return new DataCollectionOptions(this.title, this.body, this.inputType, this.collectedData);
        }
    }
}

