/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class DeleteCatalogObjectResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<String> deletedObjectIds;
    private final String deletedAt;

    @JsonCreator
    public DeleteCatalogObjectResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="deleted_object_ids") List<String> deletedObjectIds, @JsonProperty(value="deleted_at") String deletedAt) {
        this.errors = errors;
        this.deletedObjectIds = deletedObjectIds;
        this.deletedAt = deletedAt;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="deleted_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getDeletedObjectIds() {
        return this.deletedObjectIds;
    }

    @JsonGetter(value="deleted_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeletedAt() {
        return this.deletedAt;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deletedObjectIds, this.deletedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeleteCatalogObjectResponse)) {
            return false;
        }
        DeleteCatalogObjectResponse other = (DeleteCatalogObjectResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.deletedObjectIds, other.deletedObjectIds) && Objects.equals(this.deletedAt, other.deletedAt);
    }

    public String toString() {
        return "DeleteCatalogObjectResponse [errors=" + this.errors + ", deletedObjectIds=" + this.deletedObjectIds + ", deletedAt=" + this.deletedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).deletedObjectIds(this.getDeletedObjectIds()).deletedAt(this.getDeletedAt());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<String> deletedObjectIds;
        private String deletedAt;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder deletedObjectIds(List<String> deletedObjectIds) {
            this.deletedObjectIds = deletedObjectIds;
            return this;
        }

        public Builder deletedAt(String deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public DeleteCatalogObjectResponse build() {
            DeleteCatalogObjectResponse model = new DeleteCatalogObjectResponse(this.errors, this.deletedObjectIds, this.deletedAt);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

