/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Card;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DestinationDetailsCardRefundDetails {
    private final Card card;
    private final OptionalNullable<String> entryMethod;

    @JsonCreator
    public DestinationDetailsCardRefundDetails(@JsonProperty(value="card") Card card, @JsonProperty(value="entry_method") String entryMethod) {
        this.card = card;
        this.entryMethod = OptionalNullable.of((Object)entryMethod);
    }

    protected DestinationDetailsCardRefundDetails(Card card, OptionalNullable<String> entryMethod) {
        this.card = card;
        this.entryMethod = entryMethod;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Card getCard() {
        return this.card;
    }

    @JsonGetter(value="entry_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEntryMethod() {
        return this.entryMethod;
    }

    @JsonIgnore
    public String getEntryMethod() {
        return (String)OptionalNullable.getFrom(this.entryMethod);
    }

    public int hashCode() {
        return Objects.hash(this.card, this.entryMethod);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DestinationDetailsCardRefundDetails)) {
            return false;
        }
        DestinationDetailsCardRefundDetails other = (DestinationDetailsCardRefundDetails)obj;
        return Objects.equals(this.card, other.card) && Objects.equals(this.entryMethod, other.entryMethod);
    }

    public String toString() {
        return "DestinationDetailsCardRefundDetails [card=" + this.card + ", entryMethod=" + this.entryMethod + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard());
        builder.entryMethod = this.internalGetEntryMethod();
        return builder;
    }

    public static class Builder {
        private Card card;
        private OptionalNullable<String> entryMethod;

        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        public Builder entryMethod(String entryMethod) {
            this.entryMethod = OptionalNullable.of((Object)entryMethod);
            return this;
        }

        public Builder unsetEntryMethod() {
            this.entryMethod = null;
            return this;
        }

        public DestinationDetailsCardRefundDetails build() {
            return new DestinationDetailsCardRefundDetails(this.card, this.entryMethod);
        }
    }
}

