/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.DisputedPayment;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Dispute {
    private final OptionalNullable<String> disputeId;
    private final String id;
    private final Money amountMoney;
    private final String reason;
    private final String state;
    private final OptionalNullable<String> dueAt;
    private final DisputedPayment disputedPayment;
    private final OptionalNullable<List<String>> evidenceIds;
    private final String cardBrand;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<String> brandDisputeId;
    private final OptionalNullable<String> reportedDate;
    private final OptionalNullable<String> reportedAt;
    private final Integer version;
    private final OptionalNullable<String> locationId;

    @JsonCreator
    public Dispute(@JsonProperty(value="dispute_id") String disputeId, @JsonProperty(value="id") String id, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reason") String reason, @JsonProperty(value="state") String state, @JsonProperty(value="due_at") String dueAt, @JsonProperty(value="disputed_payment") DisputedPayment disputedPayment, @JsonProperty(value="evidence_ids") List<String> evidenceIds, @JsonProperty(value="card_brand") String cardBrand, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="brand_dispute_id") String brandDisputeId, @JsonProperty(value="reported_date") String reportedDate, @JsonProperty(value="reported_at") String reportedAt, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId) {
        this.disputeId = OptionalNullable.of((Object)disputeId);
        this.id = id;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.state = state;
        this.dueAt = OptionalNullable.of((Object)dueAt);
        this.disputedPayment = disputedPayment;
        this.evidenceIds = OptionalNullable.of(evidenceIds);
        this.cardBrand = cardBrand;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.brandDisputeId = OptionalNullable.of((Object)brandDisputeId);
        this.reportedDate = OptionalNullable.of((Object)reportedDate);
        this.reportedAt = OptionalNullable.of((Object)reportedAt);
        this.version = version;
        this.locationId = OptionalNullable.of((Object)locationId);
    }

    protected Dispute(OptionalNullable<String> disputeId, String id, Money amountMoney, String reason, String state, OptionalNullable<String> dueAt, DisputedPayment disputedPayment, OptionalNullable<List<String>> evidenceIds, String cardBrand, String createdAt, String updatedAt, OptionalNullable<String> brandDisputeId, OptionalNullable<String> reportedDate, OptionalNullable<String> reportedAt, Integer version, OptionalNullable<String> locationId) {
        this.disputeId = disputeId;
        this.id = id;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.state = state;
        this.dueAt = dueAt;
        this.disputedPayment = disputedPayment;
        this.evidenceIds = evidenceIds;
        this.cardBrand = cardBrand;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.brandDisputeId = brandDisputeId;
        this.reportedDate = reportedDate;
        this.reportedAt = reportedAt;
        this.version = version;
        this.locationId = locationId;
    }

    @JsonGetter(value="dispute_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDisputeId() {
        return this.disputeId;
    }

    @JsonIgnore
    public String getDisputeId() {
        return (String)OptionalNullable.getFrom(this.disputeId);
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="due_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDueAt() {
        return this.dueAt;
    }

    @JsonIgnore
    public String getDueAt() {
        return (String)OptionalNullable.getFrom(this.dueAt);
    }

    @JsonGetter(value="disputed_payment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisputedPayment getDisputedPayment() {
        return this.disputedPayment;
    }

    @JsonGetter(value="evidence_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetEvidenceIds() {
        return this.evidenceIds;
    }

    @JsonIgnore
    public List<String> getEvidenceIds() {
        return (List)OptionalNullable.getFrom(this.evidenceIds);
    }

    @JsonGetter(value="card_brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardBrand() {
        return this.cardBrand;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="brand_dispute_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBrandDisputeId() {
        return this.brandDisputeId;
    }

    @JsonIgnore
    public String getBrandDisputeId() {
        return (String)OptionalNullable.getFrom(this.brandDisputeId);
    }

    @JsonGetter(value="reported_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReportedDate() {
        return this.reportedDate;
    }

    @JsonIgnore
    public String getReportedDate() {
        return (String)OptionalNullable.getFrom(this.reportedDate);
    }

    @JsonGetter(value="reported_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReportedAt() {
        return this.reportedAt;
    }

    @JsonIgnore
    public String getReportedAt() {
        return (String)OptionalNullable.getFrom(this.reportedAt);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)obj;
        return Objects.equals(this.disputeId, other.disputeId) && Objects.equals(this.id, other.id) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.reason, other.reason) && Objects.equals(this.state, other.state) && Objects.equals(this.dueAt, other.dueAt) && Objects.equals(this.disputedPayment, other.disputedPayment) && Objects.equals(this.evidenceIds, other.evidenceIds) && Objects.equals(this.cardBrand, other.cardBrand) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.brandDisputeId, other.brandDisputeId) && Objects.equals(this.reportedDate, other.reportedDate) && Objects.equals(this.reportedAt, other.reportedAt) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "Dispute [disputeId=" + this.disputeId + ", id=" + this.id + ", amountMoney=" + this.amountMoney + ", reason=" + this.reason + ", state=" + this.state + ", dueAt=" + this.dueAt + ", disputedPayment=" + this.disputedPayment + ", evidenceIds=" + this.evidenceIds + ", cardBrand=" + this.cardBrand + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", brandDisputeId=" + this.brandDisputeId + ", reportedDate=" + this.reportedDate + ", reportedAt=" + this.reportedAt + ", version=" + this.version + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).amountMoney(this.getAmountMoney()).reason(this.getReason()).state(this.getState()).disputedPayment(this.getDisputedPayment()).cardBrand(this.getCardBrand()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).version(this.getVersion());
        builder.disputeId = this.internalGetDisputeId();
        builder.dueAt = this.internalGetDueAt();
        builder.evidenceIds = this.internalGetEvidenceIds();
        builder.brandDisputeId = this.internalGetBrandDisputeId();
        builder.reportedDate = this.internalGetReportedDate();
        builder.reportedAt = this.internalGetReportedAt();
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> disputeId;
        private String id;
        private Money amountMoney;
        private String reason;
        private String state;
        private OptionalNullable<String> dueAt;
        private DisputedPayment disputedPayment;
        private OptionalNullable<List<String>> evidenceIds;
        private String cardBrand;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<String> brandDisputeId;
        private OptionalNullable<String> reportedDate;
        private OptionalNullable<String> reportedAt;
        private Integer version;
        private OptionalNullable<String> locationId;

        public Builder disputeId(String disputeId) {
            this.disputeId = OptionalNullable.of((Object)disputeId);
            return this;
        }

        public Builder unsetDisputeId() {
            this.disputeId = null;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder dueAt(String dueAt) {
            this.dueAt = OptionalNullable.of((Object)dueAt);
            return this;
        }

        public Builder unsetDueAt() {
            this.dueAt = null;
            return this;
        }

        public Builder disputedPayment(DisputedPayment disputedPayment) {
            this.disputedPayment = disputedPayment;
            return this;
        }

        public Builder evidenceIds(List<String> evidenceIds) {
            this.evidenceIds = OptionalNullable.of(evidenceIds);
            return this;
        }

        public Builder unsetEvidenceIds() {
            this.evidenceIds = null;
            return this;
        }

        public Builder cardBrand(String cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder brandDisputeId(String brandDisputeId) {
            this.brandDisputeId = OptionalNullable.of((Object)brandDisputeId);
            return this;
        }

        public Builder unsetBrandDisputeId() {
            this.brandDisputeId = null;
            return this;
        }

        public Builder reportedDate(String reportedDate) {
            this.reportedDate = OptionalNullable.of((Object)reportedDate);
            return this;
        }

        public Builder unsetReportedDate() {
            this.reportedDate = null;
            return this;
        }

        public Builder reportedAt(String reportedAt) {
            this.reportedAt = OptionalNullable.of((Object)reportedAt);
            return this;
        }

        public Builder unsetReportedAt() {
            this.reportedAt = null;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Dispute build() {
            return new Dispute(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId);
        }
    }
}

