/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Employee {
    private final String id;
    private final OptionalNullable<String> firstName;
    private final OptionalNullable<String> lastName;
    private final OptionalNullable<String> email;
    private final OptionalNullable<String> phoneNumber;
    private final OptionalNullable<List<String>> locationIds;
    private final String status;
    private final OptionalNullable<Boolean> isOwner;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public Employee(@JsonProperty(value="id") String id, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="status") String status, @JsonProperty(value="is_owner") Boolean isOwner, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.firstName = OptionalNullable.of((Object)firstName);
        this.lastName = OptionalNullable.of((Object)lastName);
        this.email = OptionalNullable.of((Object)email);
        this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
        this.locationIds = OptionalNullable.of(locationIds);
        this.status = status;
        this.isOwner = OptionalNullable.of((Object)isOwner);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    protected Employee(String id, OptionalNullable<String> firstName, OptionalNullable<String> lastName, OptionalNullable<String> email, OptionalNullable<String> phoneNumber, OptionalNullable<List<String>> locationIds, String status, OptionalNullable<Boolean> isOwner, String createdAt, String updatedAt) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phoneNumber = phoneNumber;
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="first_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFirstName() {
        return this.firstName;
    }

    @JsonIgnore
    public String getFirstName() {
        return (String)OptionalNullable.getFrom(this.firstName);
    }

    @JsonGetter(value="last_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String getLastName() {
        return (String)OptionalNullable.getFrom(this.lastName);
    }

    @JsonGetter(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmail() {
        return this.email;
    }

    @JsonIgnore
    public String getEmail() {
        return (String)OptionalNullable.getFrom(this.email);
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.phoneNumber);
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="is_owner")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsOwner() {
        return this.isOwner;
    }

    @JsonIgnore
    public Boolean getIsOwner() {
        return (Boolean)OptionalNullable.getFrom(this.isOwner);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Employee)) {
            return false;
        }
        Employee other = (Employee)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.email, other.email) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.status, other.status) && Objects.equals(this.isOwner, other.isOwner) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "Employee [id=" + this.id + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", phoneNumber=" + this.phoneNumber + ", locationIds=" + this.locationIds + ", status=" + this.status + ", isOwner=" + this.isOwner + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).status(this.getStatus()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.firstName = this.internalGetFirstName();
        builder.lastName = this.internalGetLastName();
        builder.email = this.internalGetEmail();
        builder.phoneNumber = this.internalGetPhoneNumber();
        builder.locationIds = this.internalGetLocationIds();
        builder.isOwner = this.internalGetIsOwner();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> firstName;
        private OptionalNullable<String> lastName;
        private OptionalNullable<String> email;
        private OptionalNullable<String> phoneNumber;
        private OptionalNullable<List<String>> locationIds;
        private String status;
        private OptionalNullable<Boolean> isOwner;
        private String createdAt;
        private String updatedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = OptionalNullable.of((Object)firstName);
            return this;
        }

        public Builder unsetFirstName() {
            this.firstName = null;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = OptionalNullable.of((Object)lastName);
            return this;
        }

        public Builder unsetLastName() {
            this.lastName = null;
            return this;
        }

        public Builder email(String email) {
            this.email = OptionalNullable.of((Object)email);
            return this;
        }

        public Builder unsetEmail() {
            this.email = null;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
            return this;
        }

        public Builder unsetPhoneNumber() {
            this.phoneNumber = null;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = OptionalNullable.of((Object)isOwner);
            return this;
        }

        public Builder unsetIsOwner() {
            this.isOwner = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Employee build() {
            return new Employee(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt);
        }
    }
}

