/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class EmployeeWage {
    private final String id;
    private final OptionalNullable<String> employeeId;
    private final OptionalNullable<String> title;
    private final Money hourlyRate;

    @JsonCreator
    public EmployeeWage(@JsonProperty(value="id") String id, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="title") String title, @JsonProperty(value="hourly_rate") Money hourlyRate) {
        this.id = id;
        this.employeeId = OptionalNullable.of((Object)employeeId);
        this.title = OptionalNullable.of((Object)title);
        this.hourlyRate = hourlyRate;
    }

    protected EmployeeWage(String id, OptionalNullable<String> employeeId, OptionalNullable<String> title, Money hourlyRate) {
        this.id = id;
        this.employeeId = employeeId;
        this.title = title;
        this.hourlyRate = hourlyRate;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmployeeId() {
        return this.employeeId;
    }

    @JsonIgnore
    public String getEmployeeId() {
        return (String)OptionalNullable.getFrom(this.employeeId);
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTitle() {
        return this.title;
    }

    @JsonIgnore
    public String getTitle() {
        return (String)OptionalNullable.getFrom(this.title);
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.title, this.hourlyRate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EmployeeWage)) {
            return false;
        }
        EmployeeWage other = (EmployeeWage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.title, other.title) && Objects.equals(this.hourlyRate, other.hourlyRate);
    }

    public String toString() {
        return "EmployeeWage [id=" + this.id + ", employeeId=" + this.employeeId + ", title=" + this.title + ", hourlyRate=" + this.hourlyRate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).hourlyRate(this.getHourlyRate());
        builder.employeeId = this.internalGetEmployeeId();
        builder.title = this.internalGetTitle();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> employeeId;
        private OptionalNullable<String> title;
        private Money hourlyRate;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = OptionalNullable.of((Object)employeeId);
            return this;
        }

        public Builder unsetEmployeeId() {
            this.employeeId = null;
            return this;
        }

        public Builder title(String title) {
            this.title = OptionalNullable.of((Object)title);
            return this;
        }

        public Builder unsetTitle() {
            this.title = null;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public EmployeeWage build() {
            return new EmployeeWage(this.id, this.employeeId, this.title, this.hourlyRate);
        }
    }
}

