/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.utilities.JsonObject;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class EventData {
    private final OptionalNullable<String> type;
    private final String id;
    private final OptionalNullable<Boolean> deleted;
    private final OptionalNullable<JsonObject> object;

    @JsonCreator
    public EventData(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id, @JsonProperty(value="deleted") Boolean deleted, @JsonProperty(value="object") JsonObject object) {
        this.type = OptionalNullable.of((Object)type);
        this.id = id;
        this.deleted = OptionalNullable.of((Object)deleted);
        this.object = OptionalNullable.of((Object)((Object)object));
    }

    protected EventData(OptionalNullable<String> type, String id, OptionalNullable<Boolean> deleted, OptionalNullable<JsonObject> object) {
        this.type = type;
        this.id = id;
        this.deleted = deleted;
        this.object = object;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetType() {
        return this.type;
    }

    @JsonIgnore
    public String getType() {
        return (String)OptionalNullable.getFrom(this.type);
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="deleted")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public Boolean getDeleted() {
        return (Boolean)OptionalNullable.getFrom(this.deleted);
    }

    @JsonGetter(value="object")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<JsonObject> internalGetObject() {
        return this.object;
    }

    @JsonIgnore
    public JsonObject getObject() {
        return (JsonObject)((Object)OptionalNullable.getFrom(this.object));
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.deleted, this.object);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EventData)) {
            return false;
        }
        EventData other = (EventData)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.deleted, other.deleted) && Objects.equals(this.object, other.object);
    }

    public String toString() {
        return "EventData [type=" + this.type + ", id=" + this.id + ", deleted=" + this.deleted + ", object=" + this.object + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId());
        builder.type = this.internalGetType();
        builder.deleted = this.internalGetDeleted();
        builder.object = this.internalGetObject();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> type;
        private String id;
        private OptionalNullable<Boolean> deleted;
        private OptionalNullable<JsonObject> object;

        public Builder type(String type) {
            this.type = OptionalNullable.of((Object)type);
            return this;
        }

        public Builder unsetType() {
            this.type = null;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = OptionalNullable.of((Object)deleted);
            return this;
        }

        public Builder unsetDeleted() {
            this.deleted = null;
            return this;
        }

        public Builder object(JsonObject object) {
            this.object = OptionalNullable.of((Object)((Object)object));
            return this;
        }

        public Builder unsetObject() {
            this.object = null;
            return this;
        }

        public EventData build() {
            return new EventData(this.type, this.id, this.deleted, this.object);
        }
    }
}

