/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.FulfillmentRecipient;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class FulfillmentDeliveryDetails {
    private final FulfillmentRecipient recipient;
    private final String scheduleType;
    private final String placedAt;
    private final OptionalNullable<String> deliverAt;
    private final OptionalNullable<String> prepTimeDuration;
    private final OptionalNullable<String> deliveryWindowDuration;
    private final OptionalNullable<String> note;
    private final OptionalNullable<String> completedAt;
    private final String inProgressAt;
    private final String rejectedAt;
    private final String readyAt;
    private final String deliveredAt;
    private final String canceledAt;
    private final OptionalNullable<String> cancelReason;
    private final OptionalNullable<String> courierPickupAt;
    private final OptionalNullable<String> courierPickupWindowDuration;
    private final OptionalNullable<Boolean> isNoContactDelivery;
    private final OptionalNullable<String> dropoffNotes;
    private final OptionalNullable<String> courierProviderName;
    private final OptionalNullable<String> courierSupportPhoneNumber;
    private final OptionalNullable<String> squareDeliveryId;
    private final OptionalNullable<String> externalDeliveryId;
    private final OptionalNullable<Boolean> managedDelivery;

    @JsonCreator
    public FulfillmentDeliveryDetails(@JsonProperty(value="recipient") FulfillmentRecipient recipient, @JsonProperty(value="schedule_type") String scheduleType, @JsonProperty(value="placed_at") String placedAt, @JsonProperty(value="deliver_at") String deliverAt, @JsonProperty(value="prep_time_duration") String prepTimeDuration, @JsonProperty(value="delivery_window_duration") String deliveryWindowDuration, @JsonProperty(value="note") String note, @JsonProperty(value="completed_at") String completedAt, @JsonProperty(value="in_progress_at") String inProgressAt, @JsonProperty(value="rejected_at") String rejectedAt, @JsonProperty(value="ready_at") String readyAt, @JsonProperty(value="delivered_at") String deliveredAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="courier_pickup_at") String courierPickupAt, @JsonProperty(value="courier_pickup_window_duration") String courierPickupWindowDuration, @JsonProperty(value="is_no_contact_delivery") Boolean isNoContactDelivery, @JsonProperty(value="dropoff_notes") String dropoffNotes, @JsonProperty(value="courier_provider_name") String courierProviderName, @JsonProperty(value="courier_support_phone_number") String courierSupportPhoneNumber, @JsonProperty(value="square_delivery_id") String squareDeliveryId, @JsonProperty(value="external_delivery_id") String externalDeliveryId, @JsonProperty(value="managed_delivery") Boolean managedDelivery) {
        this.recipient = recipient;
        this.scheduleType = scheduleType;
        this.placedAt = placedAt;
        this.deliverAt = OptionalNullable.of((Object)deliverAt);
        this.prepTimeDuration = OptionalNullable.of((Object)prepTimeDuration);
        this.deliveryWindowDuration = OptionalNullable.of((Object)deliveryWindowDuration);
        this.note = OptionalNullable.of((Object)note);
        this.completedAt = OptionalNullable.of((Object)completedAt);
        this.inProgressAt = inProgressAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.deliveredAt = deliveredAt;
        this.canceledAt = canceledAt;
        this.cancelReason = OptionalNullable.of((Object)cancelReason);
        this.courierPickupAt = OptionalNullable.of((Object)courierPickupAt);
        this.courierPickupWindowDuration = OptionalNullable.of((Object)courierPickupWindowDuration);
        this.isNoContactDelivery = OptionalNullable.of((Object)isNoContactDelivery);
        this.dropoffNotes = OptionalNullable.of((Object)dropoffNotes);
        this.courierProviderName = OptionalNullable.of((Object)courierProviderName);
        this.courierSupportPhoneNumber = OptionalNullable.of((Object)courierSupportPhoneNumber);
        this.squareDeliveryId = OptionalNullable.of((Object)squareDeliveryId);
        this.externalDeliveryId = OptionalNullable.of((Object)externalDeliveryId);
        this.managedDelivery = OptionalNullable.of((Object)managedDelivery);
    }

    protected FulfillmentDeliveryDetails(FulfillmentRecipient recipient, String scheduleType, String placedAt, OptionalNullable<String> deliverAt, OptionalNullable<String> prepTimeDuration, OptionalNullable<String> deliveryWindowDuration, OptionalNullable<String> note, OptionalNullable<String> completedAt, String inProgressAt, String rejectedAt, String readyAt, String deliveredAt, String canceledAt, OptionalNullable<String> cancelReason, OptionalNullable<String> courierPickupAt, OptionalNullable<String> courierPickupWindowDuration, OptionalNullable<Boolean> isNoContactDelivery, OptionalNullable<String> dropoffNotes, OptionalNullable<String> courierProviderName, OptionalNullable<String> courierSupportPhoneNumber, OptionalNullable<String> squareDeliveryId, OptionalNullable<String> externalDeliveryId, OptionalNullable<Boolean> managedDelivery) {
        this.recipient = recipient;
        this.scheduleType = scheduleType;
        this.placedAt = placedAt;
        this.deliverAt = deliverAt;
        this.prepTimeDuration = prepTimeDuration;
        this.deliveryWindowDuration = deliveryWindowDuration;
        this.note = note;
        this.completedAt = completedAt;
        this.inProgressAt = inProgressAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.deliveredAt = deliveredAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.courierPickupAt = courierPickupAt;
        this.courierPickupWindowDuration = courierPickupWindowDuration;
        this.isNoContactDelivery = isNoContactDelivery;
        this.dropoffNotes = dropoffNotes;
        this.courierProviderName = courierProviderName;
        this.courierSupportPhoneNumber = courierSupportPhoneNumber;
        this.squareDeliveryId = squareDeliveryId;
        this.externalDeliveryId = externalDeliveryId;
        this.managedDelivery = managedDelivery;
    }

    @JsonGetter(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    @JsonGetter(value="schedule_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScheduleType() {
        return this.scheduleType;
    }

    @JsonGetter(value="placed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacedAt() {
        return this.placedAt;
    }

    @JsonGetter(value="deliver_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeliverAt() {
        return this.deliverAt;
    }

    @JsonIgnore
    public String getDeliverAt() {
        return (String)OptionalNullable.getFrom(this.deliverAt);
    }

    @JsonGetter(value="prep_time_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    @JsonIgnore
    public String getPrepTimeDuration() {
        return (String)OptionalNullable.getFrom(this.prepTimeDuration);
    }

    @JsonGetter(value="delivery_window_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeliveryWindowDuration() {
        return this.deliveryWindowDuration;
    }

    @JsonIgnore
    public String getDeliveryWindowDuration() {
        return (String)OptionalNullable.getFrom(this.deliveryWindowDuration);
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCompletedAt() {
        return this.completedAt;
    }

    @JsonIgnore
    public String getCompletedAt() {
        return (String)OptionalNullable.getFrom(this.completedAt);
    }

    @JsonGetter(value="in_progress_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInProgressAt() {
        return this.inProgressAt;
    }

    @JsonGetter(value="rejected_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonGetter(value="ready_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReadyAt() {
        return this.readyAt;
    }

    @JsonGetter(value="delivered_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeliveredAt() {
        return this.deliveredAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledAt() {
        return this.canceledAt;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCancelReason() {
        return this.cancelReason;
    }

    @JsonIgnore
    public String getCancelReason() {
        return (String)OptionalNullable.getFrom(this.cancelReason);
    }

    @JsonGetter(value="courier_pickup_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCourierPickupAt() {
        return this.courierPickupAt;
    }

    @JsonIgnore
    public String getCourierPickupAt() {
        return (String)OptionalNullable.getFrom(this.courierPickupAt);
    }

    @JsonGetter(value="courier_pickup_window_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCourierPickupWindowDuration() {
        return this.courierPickupWindowDuration;
    }

    @JsonIgnore
    public String getCourierPickupWindowDuration() {
        return (String)OptionalNullable.getFrom(this.courierPickupWindowDuration);
    }

    @JsonGetter(value="is_no_contact_delivery")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsNoContactDelivery() {
        return this.isNoContactDelivery;
    }

    @JsonIgnore
    public Boolean getIsNoContactDelivery() {
        return (Boolean)OptionalNullable.getFrom(this.isNoContactDelivery);
    }

    @JsonGetter(value="dropoff_notes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDropoffNotes() {
        return this.dropoffNotes;
    }

    @JsonIgnore
    public String getDropoffNotes() {
        return (String)OptionalNullable.getFrom(this.dropoffNotes);
    }

    @JsonGetter(value="courier_provider_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCourierProviderName() {
        return this.courierProviderName;
    }

    @JsonIgnore
    public String getCourierProviderName() {
        return (String)OptionalNullable.getFrom(this.courierProviderName);
    }

    @JsonGetter(value="courier_support_phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCourierSupportPhoneNumber() {
        return this.courierSupportPhoneNumber;
    }

    @JsonIgnore
    public String getCourierSupportPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.courierSupportPhoneNumber);
    }

    @JsonGetter(value="square_delivery_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSquareDeliveryId() {
        return this.squareDeliveryId;
    }

    @JsonIgnore
    public String getSquareDeliveryId() {
        return (String)OptionalNullable.getFrom(this.squareDeliveryId);
    }

    @JsonGetter(value="external_delivery_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetExternalDeliveryId() {
        return this.externalDeliveryId;
    }

    @JsonIgnore
    public String getExternalDeliveryId() {
        return (String)OptionalNullable.getFrom(this.externalDeliveryId);
    }

    @JsonGetter(value="managed_delivery")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetManagedDelivery() {
        return this.managedDelivery;
    }

    @JsonIgnore
    public Boolean getManagedDelivery() {
        return (Boolean)OptionalNullable.getFrom(this.managedDelivery);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.scheduleType, this.placedAt, this.deliverAt, this.prepTimeDuration, this.deliveryWindowDuration, this.note, this.completedAt, this.inProgressAt, this.rejectedAt, this.readyAt, this.deliveredAt, this.canceledAt, this.cancelReason, this.courierPickupAt, this.courierPickupWindowDuration, this.isNoContactDelivery, this.dropoffNotes, this.courierProviderName, this.courierSupportPhoneNumber, this.squareDeliveryId, this.externalDeliveryId, this.managedDelivery);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FulfillmentDeliveryDetails)) {
            return false;
        }
        FulfillmentDeliveryDetails other = (FulfillmentDeliveryDetails)obj;
        return Objects.equals(this.recipient, other.recipient) && Objects.equals(this.scheduleType, other.scheduleType) && Objects.equals(this.placedAt, other.placedAt) && Objects.equals(this.deliverAt, other.deliverAt) && Objects.equals(this.prepTimeDuration, other.prepTimeDuration) && Objects.equals(this.deliveryWindowDuration, other.deliveryWindowDuration) && Objects.equals(this.note, other.note) && Objects.equals(this.completedAt, other.completedAt) && Objects.equals(this.inProgressAt, other.inProgressAt) && Objects.equals(this.rejectedAt, other.rejectedAt) && Objects.equals(this.readyAt, other.readyAt) && Objects.equals(this.deliveredAt, other.deliveredAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.courierPickupAt, other.courierPickupAt) && Objects.equals(this.courierPickupWindowDuration, other.courierPickupWindowDuration) && Objects.equals(this.isNoContactDelivery, other.isNoContactDelivery) && Objects.equals(this.dropoffNotes, other.dropoffNotes) && Objects.equals(this.courierProviderName, other.courierProviderName) && Objects.equals(this.courierSupportPhoneNumber, other.courierSupportPhoneNumber) && Objects.equals(this.squareDeliveryId, other.squareDeliveryId) && Objects.equals(this.externalDeliveryId, other.externalDeliveryId) && Objects.equals(this.managedDelivery, other.managedDelivery);
    }

    public String toString() {
        return "FulfillmentDeliveryDetails [recipient=" + this.recipient + ", scheduleType=" + this.scheduleType + ", placedAt=" + this.placedAt + ", deliverAt=" + this.deliverAt + ", prepTimeDuration=" + this.prepTimeDuration + ", deliveryWindowDuration=" + this.deliveryWindowDuration + ", note=" + this.note + ", completedAt=" + this.completedAt + ", inProgressAt=" + this.inProgressAt + ", rejectedAt=" + this.rejectedAt + ", readyAt=" + this.readyAt + ", deliveredAt=" + this.deliveredAt + ", canceledAt=" + this.canceledAt + ", cancelReason=" + this.cancelReason + ", courierPickupAt=" + this.courierPickupAt + ", courierPickupWindowDuration=" + this.courierPickupWindowDuration + ", isNoContactDelivery=" + this.isNoContactDelivery + ", dropoffNotes=" + this.dropoffNotes + ", courierProviderName=" + this.courierProviderName + ", courierSupportPhoneNumber=" + this.courierSupportPhoneNumber + ", squareDeliveryId=" + this.squareDeliveryId + ", externalDeliveryId=" + this.externalDeliveryId + ", managedDelivery=" + this.managedDelivery + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().recipient(this.getRecipient()).scheduleType(this.getScheduleType()).placedAt(this.getPlacedAt()).inProgressAt(this.getInProgressAt()).rejectedAt(this.getRejectedAt()).readyAt(this.getReadyAt()).deliveredAt(this.getDeliveredAt()).canceledAt(this.getCanceledAt());
        builder.deliverAt = this.internalGetDeliverAt();
        builder.prepTimeDuration = this.internalGetPrepTimeDuration();
        builder.deliveryWindowDuration = this.internalGetDeliveryWindowDuration();
        builder.note = this.internalGetNote();
        builder.completedAt = this.internalGetCompletedAt();
        builder.cancelReason = this.internalGetCancelReason();
        builder.courierPickupAt = this.internalGetCourierPickupAt();
        builder.courierPickupWindowDuration = this.internalGetCourierPickupWindowDuration();
        builder.isNoContactDelivery = this.internalGetIsNoContactDelivery();
        builder.dropoffNotes = this.internalGetDropoffNotes();
        builder.courierProviderName = this.internalGetCourierProviderName();
        builder.courierSupportPhoneNumber = this.internalGetCourierSupportPhoneNumber();
        builder.squareDeliveryId = this.internalGetSquareDeliveryId();
        builder.externalDeliveryId = this.internalGetExternalDeliveryId();
        builder.managedDelivery = this.internalGetManagedDelivery();
        return builder;
    }

    public static class Builder {
        private FulfillmentRecipient recipient;
        private String scheduleType;
        private String placedAt;
        private OptionalNullable<String> deliverAt;
        private OptionalNullable<String> prepTimeDuration;
        private OptionalNullable<String> deliveryWindowDuration;
        private OptionalNullable<String> note;
        private OptionalNullable<String> completedAt;
        private String inProgressAt;
        private String rejectedAt;
        private String readyAt;
        private String deliveredAt;
        private String canceledAt;
        private OptionalNullable<String> cancelReason;
        private OptionalNullable<String> courierPickupAt;
        private OptionalNullable<String> courierPickupWindowDuration;
        private OptionalNullable<Boolean> isNoContactDelivery;
        private OptionalNullable<String> dropoffNotes;
        private OptionalNullable<String> courierProviderName;
        private OptionalNullable<String> courierSupportPhoneNumber;
        private OptionalNullable<String> squareDeliveryId;
        private OptionalNullable<String> externalDeliveryId;
        private OptionalNullable<Boolean> managedDelivery;

        public Builder recipient(FulfillmentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder deliverAt(String deliverAt) {
            this.deliverAt = OptionalNullable.of((Object)deliverAt);
            return this;
        }

        public Builder unsetDeliverAt() {
            this.deliverAt = null;
            return this;
        }

        public Builder prepTimeDuration(String prepTimeDuration) {
            this.prepTimeDuration = OptionalNullable.of((Object)prepTimeDuration);
            return this;
        }

        public Builder unsetPrepTimeDuration() {
            this.prepTimeDuration = null;
            return this;
        }

        public Builder deliveryWindowDuration(String deliveryWindowDuration) {
            this.deliveryWindowDuration = OptionalNullable.of((Object)deliveryWindowDuration);
            return this;
        }

        public Builder unsetDeliveryWindowDuration() {
            this.deliveryWindowDuration = null;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder completedAt(String completedAt) {
            this.completedAt = OptionalNullable.of((Object)completedAt);
            return this;
        }

        public Builder unsetCompletedAt() {
            this.completedAt = null;
            return this;
        }

        public Builder inProgressAt(String inProgressAt) {
            this.inProgressAt = inProgressAt;
            return this;
        }

        public Builder rejectedAt(String rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder readyAt(String readyAt) {
            this.readyAt = readyAt;
            return this;
        }

        public Builder deliveredAt(String deliveredAt) {
            this.deliveredAt = deliveredAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = OptionalNullable.of((Object)cancelReason);
            return this;
        }

        public Builder unsetCancelReason() {
            this.cancelReason = null;
            return this;
        }

        public Builder courierPickupAt(String courierPickupAt) {
            this.courierPickupAt = OptionalNullable.of((Object)courierPickupAt);
            return this;
        }

        public Builder unsetCourierPickupAt() {
            this.courierPickupAt = null;
            return this;
        }

        public Builder courierPickupWindowDuration(String courierPickupWindowDuration) {
            this.courierPickupWindowDuration = OptionalNullable.of((Object)courierPickupWindowDuration);
            return this;
        }

        public Builder unsetCourierPickupWindowDuration() {
            this.courierPickupWindowDuration = null;
            return this;
        }

        public Builder isNoContactDelivery(Boolean isNoContactDelivery) {
            this.isNoContactDelivery = OptionalNullable.of((Object)isNoContactDelivery);
            return this;
        }

        public Builder unsetIsNoContactDelivery() {
            this.isNoContactDelivery = null;
            return this;
        }

        public Builder dropoffNotes(String dropoffNotes) {
            this.dropoffNotes = OptionalNullable.of((Object)dropoffNotes);
            return this;
        }

        public Builder unsetDropoffNotes() {
            this.dropoffNotes = null;
            return this;
        }

        public Builder courierProviderName(String courierProviderName) {
            this.courierProviderName = OptionalNullable.of((Object)courierProviderName);
            return this;
        }

        public Builder unsetCourierProviderName() {
            this.courierProviderName = null;
            return this;
        }

        public Builder courierSupportPhoneNumber(String courierSupportPhoneNumber) {
            this.courierSupportPhoneNumber = OptionalNullable.of((Object)courierSupportPhoneNumber);
            return this;
        }

        public Builder unsetCourierSupportPhoneNumber() {
            this.courierSupportPhoneNumber = null;
            return this;
        }

        public Builder squareDeliveryId(String squareDeliveryId) {
            this.squareDeliveryId = OptionalNullable.of((Object)squareDeliveryId);
            return this;
        }

        public Builder unsetSquareDeliveryId() {
            this.squareDeliveryId = null;
            return this;
        }

        public Builder externalDeliveryId(String externalDeliveryId) {
            this.externalDeliveryId = OptionalNullable.of((Object)externalDeliveryId);
            return this;
        }

        public Builder unsetExternalDeliveryId() {
            this.externalDeliveryId = null;
            return this;
        }

        public Builder managedDelivery(Boolean managedDelivery) {
            this.managedDelivery = OptionalNullable.of((Object)managedDelivery);
            return this;
        }

        public Builder unsetManagedDelivery() {
            this.managedDelivery = null;
            return this;
        }

        public FulfillmentDeliveryDetails build() {
            return new FulfillmentDeliveryDetails(this.recipient, this.scheduleType, this.placedAt, this.deliverAt, this.prepTimeDuration, this.deliveryWindowDuration, this.note, this.completedAt, this.inProgressAt, this.rejectedAt, this.readyAt, this.deliveredAt, this.canceledAt, this.cancelReason, this.courierPickupAt, this.courierPickupWindowDuration, this.isNoContactDelivery, this.dropoffNotes, this.courierProviderName, this.courierSupportPhoneNumber, this.squareDeliveryId, this.externalDeliveryId, this.managedDelivery);
        }
    }
}

