/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class GiftCard {
    private final String id;
    private final String type;
    private final String ganSource;
    private final String state;
    private final Money balanceMoney;
    private final OptionalNullable<String> gan;
    private final String createdAt;
    private final List<String> customerIds;

    @JsonCreator
    public GiftCard(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id, @JsonProperty(value="gan_source") String ganSource, @JsonProperty(value="state") String state, @JsonProperty(value="balance_money") Money balanceMoney, @JsonProperty(value="gan") String gan, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="customer_ids") List<String> customerIds) {
        this.id = id;
        this.type = type;
        this.ganSource = ganSource;
        this.state = state;
        this.balanceMoney = balanceMoney;
        this.gan = OptionalNullable.of((Object)gan);
        this.createdAt = createdAt;
        this.customerIds = customerIds;
    }

    protected GiftCard(String type, String id, String ganSource, String state, Money balanceMoney, OptionalNullable<String> gan, String createdAt, List<String> customerIds) {
        this.id = id;
        this.type = type;
        this.ganSource = ganSource;
        this.state = state;
        this.balanceMoney = balanceMoney;
        this.gan = gan;
        this.createdAt = createdAt;
        this.customerIds = customerIds;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="gan_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGanSource() {
        return this.ganSource;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="balance_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBalanceMoney() {
        return this.balanceMoney;
    }

    @JsonGetter(value="gan")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetGan() {
        return this.gan;
    }

    @JsonIgnore
    public String getGan() {
        return (String)OptionalNullable.getFrom(this.gan);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCustomerIds() {
        return this.customerIds;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.ganSource, this.state, this.balanceMoney, this.gan, this.createdAt, this.customerIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCard)) {
            return false;
        }
        GiftCard other = (GiftCard)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.ganSource, other.ganSource) && Objects.equals(this.state, other.state) && Objects.equals(this.balanceMoney, other.balanceMoney) && Objects.equals(this.gan, other.gan) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.customerIds, other.customerIds);
    }

    public String toString() {
        return "GiftCard [type=" + this.type + ", id=" + this.id + ", ganSource=" + this.ganSource + ", state=" + this.state + ", balanceMoney=" + this.balanceMoney + ", gan=" + this.gan + ", createdAt=" + this.createdAt + ", customerIds=" + this.customerIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type).id(this.getId()).ganSource(this.getGanSource()).state(this.getState()).balanceMoney(this.getBalanceMoney()).createdAt(this.getCreatedAt()).customerIds(this.getCustomerIds());
        builder.gan = this.internalGetGan();
        return builder;
    }

    public static class Builder {
        private String type;
        private String id;
        private String ganSource;
        private String state;
        private Money balanceMoney;
        private OptionalNullable<String> gan;
        private String createdAt;
        private List<String> customerIds;

        public Builder(String type) {
            this.type = type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ganSource(String ganSource) {
            this.ganSource = ganSource;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder balanceMoney(Money balanceMoney) {
            this.balanceMoney = balanceMoney;
            return this;
        }

        public Builder gan(String gan) {
            this.gan = OptionalNullable.of((Object)gan);
            return this;
        }

        public Builder unsetGan() {
            this.gan = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public GiftCard build() {
            return new GiftCard(this.type, this.id, this.ganSource, this.state, this.balanceMoney, this.gan, this.createdAt, this.customerIds);
        }
    }
}

