/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class GiftCardActivityRedeem {
    private final Money amountMoney;
    private final String paymentId;
    private final OptionalNullable<String> referenceId;
    private final String status;

    @JsonCreator
    public GiftCardActivityRedeem(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="status") String status) {
        this.amountMoney = amountMoney;
        this.paymentId = paymentId;
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.status = status;
    }

    protected GiftCardActivityRedeem(Money amountMoney, String paymentId, OptionalNullable<String> referenceId, String status) {
        this.amountMoney = amountMoney;
        this.paymentId = paymentId;
        this.referenceId = referenceId;
        this.status = status;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.paymentId, this.referenceId, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityRedeem)) {
            return false;
        }
        GiftCardActivityRedeem other = (GiftCardActivityRedeem)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "GiftCardActivityRedeem [amountMoney=" + this.amountMoney + ", paymentId=" + this.paymentId + ", referenceId=" + this.referenceId + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney).paymentId(this.getPaymentId()).status(this.getStatus());
        builder.referenceId = this.internalGetReferenceId();
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String paymentId;
        private OptionalNullable<String> referenceId;
        private String status;

        public Builder(Money amountMoney) {
            this.amountMoney = amountMoney;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public GiftCardActivityRedeem build() {
            return new GiftCardActivityRedeem(this.amountMoney, this.paymentId, this.referenceId, this.status);
        }
    }
}

