/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogMeasurementUnit;
import com.squareup.square.models.InventoryAdjustment;
import com.squareup.square.models.InventoryPhysicalCount;
import com.squareup.square.models.InventoryTransfer;
import java.util.Objects;

public class InventoryChange {
    private final String type;
    private final InventoryPhysicalCount physicalCount;
    private final InventoryAdjustment adjustment;
    private final InventoryTransfer transfer;
    private final CatalogMeasurementUnit measurementUnit;
    private final String measurementUnitId;

    @JsonCreator
    public InventoryChange(@JsonProperty(value="type") String type, @JsonProperty(value="physical_count") InventoryPhysicalCount physicalCount, @JsonProperty(value="adjustment") InventoryAdjustment adjustment, @JsonProperty(value="transfer") InventoryTransfer transfer, @JsonProperty(value="measurement_unit") CatalogMeasurementUnit measurementUnit, @JsonProperty(value="measurement_unit_id") String measurementUnitId) {
        this.type = type;
        this.physicalCount = physicalCount;
        this.adjustment = adjustment;
        this.transfer = transfer;
        this.measurementUnit = measurementUnit;
        this.measurementUnitId = measurementUnitId;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="physical_count")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryPhysicalCount getPhysicalCount() {
        return this.physicalCount;
    }

    @JsonGetter(value="adjustment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryAdjustment getAdjustment() {
        return this.adjustment;
    }

    @JsonGetter(value="transfer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryTransfer getTransfer() {
        return this.transfer;
    }

    @JsonGetter(value="measurement_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogMeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonGetter(value="measurement_unit_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMeasurementUnitId() {
        return this.measurementUnitId;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.physicalCount, this.adjustment, this.transfer, this.measurementUnit, this.measurementUnitId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InventoryChange)) {
            return false;
        }
        InventoryChange other = (InventoryChange)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.physicalCount, other.physicalCount) && Objects.equals(this.adjustment, other.adjustment) && Objects.equals(this.transfer, other.transfer) && Objects.equals(this.measurementUnit, other.measurementUnit) && Objects.equals(this.measurementUnitId, other.measurementUnitId);
    }

    public String toString() {
        return "InventoryChange [type=" + this.type + ", physicalCount=" + this.physicalCount + ", adjustment=" + this.adjustment + ", transfer=" + this.transfer + ", measurementUnit=" + this.measurementUnit + ", measurementUnitId=" + this.measurementUnitId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).physicalCount(this.getPhysicalCount()).adjustment(this.getAdjustment()).transfer(this.getTransfer()).measurementUnit(this.getMeasurementUnit()).measurementUnitId(this.getMeasurementUnitId());
        return builder;
    }

    public static class Builder {
        private String type;
        private InventoryPhysicalCount physicalCount;
        private InventoryAdjustment adjustment;
        private InventoryTransfer transfer;
        private CatalogMeasurementUnit measurementUnit;
        private String measurementUnitId;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder physicalCount(InventoryPhysicalCount physicalCount) {
            this.physicalCount = physicalCount;
            return this;
        }

        public Builder adjustment(InventoryAdjustment adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        public Builder transfer(InventoryTransfer transfer) {
            this.transfer = transfer;
            return this;
        }

        public Builder measurementUnit(CatalogMeasurementUnit measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder measurementUnitId(String measurementUnitId) {
            this.measurementUnitId = measurementUnitId;
            return this;
        }

        public InventoryChange build() {
            return new InventoryChange(this.type, this.physicalCount, this.adjustment, this.transfer, this.measurementUnit, this.measurementUnitId);
        }
    }
}

