/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.SourceApplication;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class InventoryTransfer {
    private final String id;
    private final OptionalNullable<String> referenceId;
    private final String state;
    private final OptionalNullable<String> fromLocationId;
    private final OptionalNullable<String> toLocationId;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<String> catalogObjectType;
    private final OptionalNullable<String> quantity;
    private final OptionalNullable<String> occurredAt;
    private final String createdAt;
    private final SourceApplication source;
    private final OptionalNullable<String> employeeId;
    private final OptionalNullable<String> teamMemberId;

    @JsonCreator
    public InventoryTransfer(@JsonProperty(value="id") String id, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="state") String state, @JsonProperty(value="from_location_id") String fromLocationId, @JsonProperty(value="to_location_id") String toLocationId, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_object_type") String catalogObjectType, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="occurred_at") String occurredAt, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="source") SourceApplication source, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.state = state;
        this.fromLocationId = OptionalNullable.of((Object)fromLocationId);
        this.toLocationId = OptionalNullable.of((Object)toLocationId);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogObjectType = OptionalNullable.of((Object)catalogObjectType);
        this.quantity = OptionalNullable.of((Object)quantity);
        this.occurredAt = OptionalNullable.of((Object)occurredAt);
        this.createdAt = createdAt;
        this.source = source;
        this.employeeId = OptionalNullable.of((Object)employeeId);
        this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
    }

    protected InventoryTransfer(String id, OptionalNullable<String> referenceId, String state, OptionalNullable<String> fromLocationId, OptionalNullable<String> toLocationId, OptionalNullable<String> catalogObjectId, OptionalNullable<String> catalogObjectType, OptionalNullable<String> quantity, OptionalNullable<String> occurredAt, String createdAt, SourceApplication source, OptionalNullable<String> employeeId, OptionalNullable<String> teamMemberId) {
        this.id = id;
        this.referenceId = referenceId;
        this.state = state;
        this.fromLocationId = fromLocationId;
        this.toLocationId = toLocationId;
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.quantity = quantity;
        this.occurredAt = occurredAt;
        this.createdAt = createdAt;
        this.source = source;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="from_location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFromLocationId() {
        return this.fromLocationId;
    }

    @JsonIgnore
    public String getFromLocationId() {
        return (String)OptionalNullable.getFrom(this.fromLocationId);
    }

    @JsonGetter(value="to_location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetToLocationId() {
        return this.toLocationId;
    }

    @JsonIgnore
    public String getToLocationId() {
        return (String)OptionalNullable.getFrom(this.toLocationId);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_object_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonIgnore
    public String getCatalogObjectType() {
        return (String)OptionalNullable.getFrom(this.catalogObjectType);
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetQuantity() {
        return this.quantity;
    }

    @JsonIgnore
    public String getQuantity() {
        return (String)OptionalNullable.getFrom(this.quantity);
    }

    @JsonGetter(value="occurred_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOccurredAt() {
        return this.occurredAt;
    }

    @JsonIgnore
    public String getOccurredAt() {
        return (String)OptionalNullable.getFrom(this.occurredAt);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SourceApplication getSource() {
        return this.source;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmployeeId() {
        return this.employeeId;
    }

    @JsonIgnore
    public String getEmployeeId() {
        return (String)OptionalNullable.getFrom(this.employeeId);
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonIgnore
    public String getTeamMemberId() {
        return (String)OptionalNullable.getFrom(this.teamMemberId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.state, this.fromLocationId, this.toLocationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InventoryTransfer)) {
            return false;
        }
        InventoryTransfer other = (InventoryTransfer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.state, other.state) && Objects.equals(this.fromLocationId, other.fromLocationId) && Objects.equals(this.toLocationId, other.toLocationId) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogObjectType, other.catalogObjectType) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.occurredAt, other.occurredAt) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.source, other.source) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "InventoryTransfer [id=" + this.id + ", referenceId=" + this.referenceId + ", state=" + this.state + ", fromLocationId=" + this.fromLocationId + ", toLocationId=" + this.toLocationId + ", catalogObjectId=" + this.catalogObjectId + ", catalogObjectType=" + this.catalogObjectType + ", quantity=" + this.quantity + ", occurredAt=" + this.occurredAt + ", createdAt=" + this.createdAt + ", source=" + this.source + ", employeeId=" + this.employeeId + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).createdAt(this.getCreatedAt()).source(this.getSource());
        builder.referenceId = this.internalGetReferenceId();
        builder.fromLocationId = this.internalGetFromLocationId();
        builder.toLocationId = this.internalGetToLocationId();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogObjectType = this.internalGetCatalogObjectType();
        builder.quantity = this.internalGetQuantity();
        builder.occurredAt = this.internalGetOccurredAt();
        builder.employeeId = this.internalGetEmployeeId();
        builder.teamMemberId = this.internalGetTeamMemberId();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> referenceId;
        private String state;
        private OptionalNullable<String> fromLocationId;
        private OptionalNullable<String> toLocationId;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<String> catalogObjectType;
        private OptionalNullable<String> quantity;
        private OptionalNullable<String> occurredAt;
        private String createdAt;
        private SourceApplication source;
        private OptionalNullable<String> employeeId;
        private OptionalNullable<String> teamMemberId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder fromLocationId(String fromLocationId) {
            this.fromLocationId = OptionalNullable.of((Object)fromLocationId);
            return this;
        }

        public Builder unsetFromLocationId() {
            this.fromLocationId = null;
            return this;
        }

        public Builder toLocationId(String toLocationId) {
            this.toLocationId = OptionalNullable.of((Object)toLocationId);
            return this;
        }

        public Builder unsetToLocationId() {
            this.toLocationId = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = OptionalNullable.of((Object)catalogObjectType);
            return this;
        }

        public Builder unsetCatalogObjectType() {
            this.catalogObjectType = null;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = OptionalNullable.of((Object)quantity);
            return this;
        }

        public Builder unsetQuantity() {
            this.quantity = null;
            return this;
        }

        public Builder occurredAt(String occurredAt) {
            this.occurredAt = OptionalNullable.of((Object)occurredAt);
            return this;
        }

        public Builder unsetOccurredAt() {
            this.occurredAt = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder source(SourceApplication source) {
            this.source = source;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = OptionalNullable.of((Object)employeeId);
            return this;
        }

        public Builder unsetEmployeeId() {
            this.employeeId = null;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
            return this;
        }

        public Builder unsetTeamMemberId() {
            this.teamMemberId = null;
            return this;
        }

        public InventoryTransfer build() {
            return new InventoryTransfer(this.id, this.referenceId, this.state, this.fromLocationId, this.toLocationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId);
        }
    }
}

