/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class InvoiceCustomField {
    private final OptionalNullable<String> label;
    private final OptionalNullable<String> value;
    private final String placement;

    @JsonCreator
    public InvoiceCustomField(@JsonProperty(value="label") String label, @JsonProperty(value="value") String value, @JsonProperty(value="placement") String placement) {
        this.label = OptionalNullable.of((Object)label);
        this.value = OptionalNullable.of((Object)value);
        this.placement = placement;
    }

    protected InvoiceCustomField(OptionalNullable<String> label, OptionalNullable<String> value, String placement) {
        this.label = label;
        this.value = value;
        this.placement = placement;
    }

    @JsonGetter(value="label")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLabel() {
        return this.label;
    }

    @JsonIgnore
    public String getLabel() {
        return (String)OptionalNullable.getFrom(this.label);
    }

    @JsonGetter(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetValue() {
        return this.value;
    }

    @JsonIgnore
    public String getValue() {
        return (String)OptionalNullable.getFrom(this.value);
    }

    @JsonGetter(value="placement")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacement() {
        return this.placement;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.value, this.placement);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceCustomField)) {
            return false;
        }
        InvoiceCustomField other = (InvoiceCustomField)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.value, other.value) && Objects.equals(this.placement, other.placement);
    }

    public String toString() {
        return "InvoiceCustomField [label=" + this.label + ", value=" + this.value + ", placement=" + this.placement + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().placement(this.getPlacement());
        builder.label = this.internalGetLabel();
        builder.value = this.internalGetValue();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> label;
        private OptionalNullable<String> value;
        private String placement;

        public Builder label(String label) {
            this.label = OptionalNullable.of((Object)label);
            return this;
        }

        public Builder unsetLabel() {
            this.label = null;
            return this;
        }

        public Builder value(String value) {
            this.value = OptionalNullable.of((Object)value);
            return this;
        }

        public Builder unsetValue() {
            this.value = null;
            return this;
        }

        public Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        public InvoiceCustomField build() {
            return new InvoiceCustomField(this.label, this.value, this.placement);
        }
    }
}

