/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class InvoicePaymentReminder {
    private final String uid;
    private final OptionalNullable<Integer> relativeScheduledDays;
    private final OptionalNullable<String> message;
    private final String status;
    private final String sentAt;

    @JsonCreator
    public InvoicePaymentReminder(@JsonProperty(value="uid") String uid, @JsonProperty(value="relative_scheduled_days") Integer relativeScheduledDays, @JsonProperty(value="message") String message, @JsonProperty(value="status") String status, @JsonProperty(value="sent_at") String sentAt) {
        this.uid = uid;
        this.relativeScheduledDays = OptionalNullable.of((Object)relativeScheduledDays);
        this.message = OptionalNullable.of((Object)message);
        this.status = status;
        this.sentAt = sentAt;
    }

    protected InvoicePaymentReminder(String uid, OptionalNullable<Integer> relativeScheduledDays, OptionalNullable<String> message, String status, String sentAt) {
        this.uid = uid;
        this.relativeScheduledDays = relativeScheduledDays;
        this.message = message;
        this.status = status;
        this.sentAt = sentAt;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="relative_scheduled_days")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetRelativeScheduledDays() {
        return this.relativeScheduledDays;
    }

    @JsonIgnore
    public Integer getRelativeScheduledDays() {
        return (Integer)OptionalNullable.getFrom(this.relativeScheduledDays);
    }

    @JsonGetter(value="message")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getMessage() {
        return (String)OptionalNullable.getFrom(this.message);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="sent_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSentAt() {
        return this.sentAt;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.relativeScheduledDays, this.message, this.status, this.sentAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoicePaymentReminder)) {
            return false;
        }
        InvoicePaymentReminder other = (InvoicePaymentReminder)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.relativeScheduledDays, other.relativeScheduledDays) && Objects.equals(this.message, other.message) && Objects.equals(this.status, other.status) && Objects.equals(this.sentAt, other.sentAt);
    }

    public String toString() {
        return "InvoicePaymentReminder [uid=" + this.uid + ", relativeScheduledDays=" + this.relativeScheduledDays + ", message=" + this.message + ", status=" + this.status + ", sentAt=" + this.sentAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).status(this.getStatus()).sentAt(this.getSentAt());
        builder.relativeScheduledDays = this.internalGetRelativeScheduledDays();
        builder.message = this.internalGetMessage();
        return builder;
    }

    public static class Builder {
        private String uid;
        private OptionalNullable<Integer> relativeScheduledDays;
        private OptionalNullable<String> message;
        private String status;
        private String sentAt;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder relativeScheduledDays(Integer relativeScheduledDays) {
            this.relativeScheduledDays = OptionalNullable.of((Object)relativeScheduledDays);
            return this;
        }

        public Builder unsetRelativeScheduledDays() {
            this.relativeScheduledDays = null;
            return this;
        }

        public Builder message(String message) {
            this.message = OptionalNullable.of((Object)message);
            return this;
        }

        public Builder unsetMessage() {
            this.message = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder sentAt(String sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public InvoicePaymentReminder build() {
            return new InvoicePaymentReminder(this.uid, this.relativeScheduledDays, this.message, this.status, this.sentAt);
        }
    }
}

