/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.InvoiceFilter;
import com.squareup.square.models.InvoiceSort;
import java.util.Objects;

public class InvoiceQuery {
    private final InvoiceFilter filter;
    private final InvoiceSort sort;

    @JsonCreator
    public InvoiceQuery(@JsonProperty(value="filter") InvoiceFilter filter, @JsonProperty(value="sort") InvoiceSort sort) {
        this.filter = filter;
        this.sort = sort;
    }

    @JsonGetter(value="filter")
    public InvoiceFilter getFilter() {
        return this.filter;
    }

    @JsonGetter(value="sort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceSort getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceQuery)) {
            return false;
        }
        InvoiceQuery other = (InvoiceQuery)obj;
        return Objects.equals(this.filter, other.filter) && Objects.equals(this.sort, other.sort);
    }

    public String toString() {
        return "InvoiceQuery [filter=" + this.filter + ", sort=" + this.sort + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.filter).sort(this.getSort());
        return builder;
    }

    public static class Builder {
        private InvoiceFilter filter;
        private InvoiceSort sort;

        public Builder(InvoiceFilter filter) {
            this.filter = filter;
        }

        public Builder filter(InvoiceFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(InvoiceSort sort) {
            this.sort = sort;
            return this;
        }

        public InvoiceQuery build() {
            return new InvoiceQuery(this.filter, this.sort);
        }
    }
}

