/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ItemVariationLocationOverrides {
    private final OptionalNullable<String> locationId;
    private final Money priceMoney;
    private final String pricingType;
    private final OptionalNullable<Boolean> trackInventory;
    private final String inventoryAlertType;
    private final OptionalNullable<Long> inventoryAlertThreshold;
    private final Boolean soldOut;
    private final String soldOutValidUntil;

    @JsonCreator
    public ItemVariationLocationOverrides(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="pricing_type") String pricingType, @JsonProperty(value="track_inventory") Boolean trackInventory, @JsonProperty(value="inventory_alert_type") String inventoryAlertType, @JsonProperty(value="inventory_alert_threshold") Long inventoryAlertThreshold, @JsonProperty(value="sold_out") Boolean soldOut, @JsonProperty(value="sold_out_valid_until") String soldOutValidUntil) {
        this.locationId = OptionalNullable.of((Object)locationId);
        this.priceMoney = priceMoney;
        this.pricingType = pricingType;
        this.trackInventory = OptionalNullable.of((Object)trackInventory);
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = OptionalNullable.of((Object)inventoryAlertThreshold);
        this.soldOut = soldOut;
        this.soldOutValidUntil = soldOutValidUntil;
    }

    protected ItemVariationLocationOverrides(OptionalNullable<String> locationId, Money priceMoney, String pricingType, OptionalNullable<Boolean> trackInventory, String inventoryAlertType, OptionalNullable<Long> inventoryAlertThreshold, Boolean soldOut, String soldOutValidUntil) {
        this.locationId = locationId;
        this.priceMoney = priceMoney;
        this.pricingType = pricingType;
        this.trackInventory = trackInventory;
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        this.soldOut = soldOut;
        this.soldOutValidUntil = soldOutValidUntil;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="pricing_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPricingType() {
        return this.pricingType;
    }

    @JsonGetter(value="track_inventory")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetTrackInventory() {
        return this.trackInventory;
    }

    @JsonIgnore
    public Boolean getTrackInventory() {
        return (Boolean)OptionalNullable.getFrom(this.trackInventory);
    }

    @JsonGetter(value="inventory_alert_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    @JsonGetter(value="inventory_alert_threshold")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    @JsonIgnore
    public Long getInventoryAlertThreshold() {
        return (Long)OptionalNullable.getFrom(this.inventoryAlertThreshold);
    }

    @JsonGetter(value="sold_out")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSoldOut() {
        return this.soldOut;
    }

    @JsonGetter(value="sold_out_valid_until")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSoldOutValidUntil() {
        return this.soldOutValidUntil;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemVariationLocationOverrides)) {
            return false;
        }
        ItemVariationLocationOverrides other = (ItemVariationLocationOverrides)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.pricingType, other.pricingType) && Objects.equals(this.trackInventory, other.trackInventory) && Objects.equals(this.inventoryAlertType, other.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, other.inventoryAlertThreshold) && Objects.equals(this.soldOut, other.soldOut) && Objects.equals(this.soldOutValidUntil, other.soldOutValidUntil);
    }

    public String toString() {
        return "ItemVariationLocationOverrides [locationId=" + this.locationId + ", priceMoney=" + this.priceMoney + ", pricingType=" + this.pricingType + ", trackInventory=" + this.trackInventory + ", inventoryAlertType=" + this.inventoryAlertType + ", inventoryAlertThreshold=" + this.inventoryAlertThreshold + ", soldOut=" + this.soldOut + ", soldOutValidUntil=" + this.soldOutValidUntil + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().priceMoney(this.getPriceMoney()).pricingType(this.getPricingType()).inventoryAlertType(this.getInventoryAlertType()).soldOut(this.getSoldOut()).soldOutValidUntil(this.getSoldOutValidUntil());
        builder.locationId = this.internalGetLocationId();
        builder.trackInventory = this.internalGetTrackInventory();
        builder.inventoryAlertThreshold = this.internalGetInventoryAlertThreshold();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationId;
        private Money priceMoney;
        private String pricingType;
        private OptionalNullable<Boolean> trackInventory;
        private String inventoryAlertType;
        private OptionalNullable<Long> inventoryAlertThreshold;
        private Boolean soldOut;
        private String soldOutValidUntil;

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder pricingType(String pricingType) {
            this.pricingType = pricingType;
            return this;
        }

        public Builder trackInventory(Boolean trackInventory) {
            this.trackInventory = OptionalNullable.of((Object)trackInventory);
            return this;
        }

        public Builder unsetTrackInventory() {
            this.trackInventory = null;
            return this;
        }

        public Builder inventoryAlertType(String inventoryAlertType) {
            this.inventoryAlertType = inventoryAlertType;
            return this;
        }

        public Builder inventoryAlertThreshold(Long inventoryAlertThreshold) {
            this.inventoryAlertThreshold = OptionalNullable.of((Object)inventoryAlertThreshold);
            return this;
        }

        public Builder unsetInventoryAlertThreshold() {
            this.inventoryAlertThreshold = null;
            return this;
        }

        public Builder soldOut(Boolean soldOut) {
            this.soldOut = soldOut;
            return this;
        }

        public Builder soldOutValidUntil(String soldOutValidUntil) {
            this.soldOutValidUntil = soldOutValidUntil;
            return this;
        }

        public ItemVariationLocationOverrides build() {
            return new ItemVariationLocationOverrides(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil);
        }
    }
}

