/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.BreakType;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListBreakTypesResponse {
    private HttpContext httpContext;
    private final List<BreakType> breakTypes;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListBreakTypesResponse(@JsonProperty(value="break_types") List<BreakType> breakTypes, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.breakTypes = breakTypes;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="break_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<BreakType> getBreakTypes() {
        return this.breakTypes;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.breakTypes, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBreakTypesResponse)) {
            return false;
        }
        ListBreakTypesResponse other = (ListBreakTypesResponse)obj;
        return Objects.equals(this.breakTypes, other.breakTypes) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListBreakTypesResponse [breakTypes=" + this.breakTypes + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().breakTypes(this.getBreakTypes()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<BreakType> breakTypes;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder breakTypes(List<BreakType> breakTypes) {
            this.breakTypes = breakTypes;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListBreakTypesResponse build() {
            ListBreakTypesResponse model = new ListBreakTypesResponse(this.breakTypes, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

